/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.VaultBootstrapConfiguration;
import org.springframework.cloud.vault.config.VaultConfigurationUtil;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationStepsOperator;
import org.springframework.vault.authentication.CachingVaultTokenSupplier;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ReactiveLifecycleAwareSessionManager;
import org.springframework.vault.authentication.ReactiveSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.client.ClientHttpConnectorFactory;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.client.WebClientBuilder;
import org.springframework.vault.client.WebClientCustomizer;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultTemplate;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="${spring.cloud.vault.reactive.enabled:true}")
@ConditionalOnClass(value={Flux.class, WebClient.class, ReactiveVaultOperations.class, HttpClient.class})
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFF5)
public class VaultReactiveBootstrapConfiguration {
    private final VaultProperties vaultProperties;
    private final WebClientBuilder webClientBuilder;

    public VaultReactiveBootstrapConfiguration(VaultProperties vaultProperties, ObjectProvider<VaultEndpointProvider> endpointProvider, ObjectProvider<List<WebClientCustomizer>> webClientCustomizers) {
        this.vaultProperties = vaultProperties;
        VaultEndpointProvider provider = (VaultEndpointProvider)endpointProvider.getIfAvailable();
        if (provider == null) {
            provider = SimpleVaultEndpointProvider.of((VaultEndpoint)VaultConfigurationUtil.createVaultEndpoint(vaultProperties));
        }
        this.webClientBuilder = WebClientBuilder.builder().httpConnector(VaultReactiveBootstrapConfiguration.createConnector(this.vaultProperties)).endpointProvider(provider);
        ArrayList customizers = new ArrayList((Collection)webClientCustomizers.getIfAvailable(Collections::emptyList));
        AnnotationAwareOrderComparator.sort(customizers);
        customizers.forEach(xva$0 -> this.webClientBuilder.customizers(new WebClientCustomizer[]{xva$0}));
        if (StringUtils.hasText((String)this.vaultProperties.getNamespace())) {
            this.webClientBuilder.defaultHeader("X-Vault-Namespace", this.vaultProperties.getNamespace());
        }
    }

    private static ClientHttpConnector createConnector(VaultProperties vaultProperties) {
        ClientOptions clientOptions = new ClientOptions(Duration.ofMillis(vaultProperties.getConnectionTimeout()), Duration.ofMillis(vaultProperties.getReadTimeout()));
        SslConfiguration sslConfiguration = VaultConfigurationUtil.createSslConfiguration(vaultProperties.getSsl());
        return ClientHttpConnectorFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveVaultOperations.class})
    public ReactiveVaultTemplate reactiveVaultTemplate(ReactiveSessionManager tokenSupplier) {
        return new ReactiveVaultTemplate(this.webClientBuilder, (VaultTokenSupplier)tokenSupplier);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveSessionManager reactiveVaultSessionManager(BeanFactory beanFactory, ObjectFactory<VaultBootstrapConfiguration.TaskSchedulerWrapper> asyncTaskExecutorFactory) {
        VaultTokenSupplier vaultTokenSupplier = (VaultTokenSupplier)beanFactory.getBean("vaultTokenSupplier", VaultTokenSupplier.class);
        if (this.vaultProperties.getConfig().getLifecycle().isEnabled()) {
            WebClient webClient = this.webClientBuilder.build();
            return new ReactiveLifecycleAwareSessionManager(vaultTokenSupplier, (TaskScheduler)((VaultBootstrapConfiguration.TaskSchedulerWrapper)asyncTaskExecutorFactory.getObject()).getTaskScheduler(), webClient);
        }
        return CachingVaultTokenSupplier.of((VaultTokenSupplier)vaultTokenSupplier);
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionManager vaultSessionManager(ReactiveSessionManager sessionManager) {
        return () -> ((Mono)sessionManager.getSessionToken()).block();
    }

    @Bean
    @ConditionalOnMissingBean(name={"vaultTokenSupplier"})
    public VaultTokenSupplier vaultTokenSupplier(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Object[] authStepsFactories = beanFactory.getBeanNamesForType(AuthenticationStepsFactory.class);
        if (!ObjectUtils.isEmpty((Object[])authStepsFactories)) {
            AuthenticationStepsFactory factory = (AuthenticationStepsFactory)beanFactory.getBean(AuthenticationStepsFactory.class);
            return this.createAuthenticationStepsOperator(factory);
        }
        Object[] clientAuthentications = beanFactory.getBeanNamesForType(ClientAuthentication.class);
        if (!ObjectUtils.isEmpty((Object[])clientAuthentications)) {
            ClientAuthentication clientAuthentication = (ClientAuthentication)beanFactory.getBean(ClientAuthentication.class);
            if (clientAuthentication instanceof TokenAuthentication) {
                TokenAuthentication authentication = (TokenAuthentication)clientAuthentication;
                return () -> Mono.just((Object)authentication.login());
            }
            if (clientAuthentication instanceof AuthenticationStepsFactory) {
                return this.createAuthenticationStepsOperator((AuthenticationStepsFactory)clientAuthentication);
            }
            throw new IllegalStateException(String.format("Cannot construct VaultTokenSupplier from %s. ClientAuthentication must implement AuthenticationStepsFactory or be TokenAuthentication", clientAuthentication));
        }
        throw new IllegalStateException("Cannot construct VaultTokenSupplier. Please configure VaultTokenSupplier bean named vaultTokenSupplier.");
    }

    private VaultTokenSupplier createAuthenticationStepsOperator(AuthenticationStepsFactory factory) {
        WebClient webClient = this.webClientBuilder.build();
        return new AuthenticationStepsOperator(factory.getAuthenticationSteps(), webClient);
    }
}

