/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.vault.config.DefaultSecretBackendConfigurer;
import org.springframework.cloud.vault.config.GenericSecretBackendMetadata;
import org.springframework.cloud.vault.config.KeyValueSecretBackendMetadata;
import org.springframework.cloud.vault.config.LeasingVaultPropertySourceLocator;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.SecretBackendFactories;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultBootstrapConfiguration;
import org.springframework.cloud.vault.config.VaultConfigTemplate;
import org.springframework.cloud.vault.config.VaultConfigurer;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.cloud.vault.config.VaultKeyValueBackendProperties;
import org.springframework.cloud.vault.config.VaultKeyValueBackendPropertiesSupport;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySourceLocator;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.lease.SecretLeaseContainer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VaultGenericBackendProperties.class, VaultKeyValueBackendProperties.class})
@Order(value=0x7FFFFFF5)
public class VaultBootstrapPropertySourceConfiguration
implements InitializingBean {
    private final ConfigurableApplicationContext applicationContext;
    private Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors;
    private Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories;

    public VaultBootstrapPropertySourceConfiguration(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.vaultSecretBackendDescriptors = this.applicationContext.getBeansOfType(VaultSecretBackendDescriptor.class).values();
        this.factories = this.applicationContext.getBeansOfType(SecretBackendMetadataFactory.class).values();
    }

    @Bean
    public PropertySourceLocator vaultPropertySourceLocator(VaultOperations operations, VaultProperties vaultProperties, VaultKeyValueBackendProperties kvBackendProperties, VaultGenericBackendProperties genericBackendProperties, ObjectFactory<SecretLeaseContainer> secretLeaseContainerObjectFactory) {
        VaultConfigTemplate vaultConfigTemplate = new VaultConfigTemplate(operations, vaultProperties);
        PropertySourceLocatorConfiguration configuration = this.getPropertySourceConfiguration(Arrays.asList(kvBackendProperties, genericBackendProperties));
        VaultProperties.Lifecycle lifecycle = vaultProperties.getConfig().getLifecycle();
        if (lifecycle.isEnabled()) {
            this.applicationContext.registerShutdownHook();
            SecretLeaseContainer secretLeaseContainer = (SecretLeaseContainer)secretLeaseContainerObjectFactory.getObject();
            if (lifecycle.getMinRenewal() != null) {
                secretLeaseContainer.setMinRenewal(lifecycle.getMinRenewal());
            }
            if (lifecycle.getExpiryThreshold() != null) {
                secretLeaseContainer.setExpiryThreshold(lifecycle.getExpiryThreshold());
            }
            if (lifecycle.getLeaseEndpoints() != null) {
                secretLeaseContainer.setLeaseEndpoints(lifecycle.getLeaseEndpoints());
            }
            secretLeaseContainer.start();
            return new LeasingVaultPropertySourceLocator(vaultProperties, configuration, secretLeaseContainer);
        }
        return new VaultPropertySourceLocator(vaultConfigTemplate, vaultProperties, configuration);
    }

    private PropertySourceLocatorConfiguration getPropertySourceConfiguration(List<VaultKeyValueBackendPropertiesSupport> keyValueBackends) {
        Collection<SecretBackendMetadata> backendAccessors;
        Collection configurers = this.applicationContext.getBeansOfType(VaultConfigurer.class).values();
        DefaultSecretBackendConfigurer secretBackendConfigurer = new DefaultSecretBackendConfigurer();
        if (configurers.isEmpty()) {
            secretBackendConfigurer.registerDefaultGenericSecretBackends(true).registerDefaultDiscoveredSecretBackends(true);
        } else {
            for (VaultConfigurer vaultConfigurer : configurers) {
                vaultConfigurer.addSecretBackends(secretBackendConfigurer);
            }
        }
        if (secretBackendConfigurer.isRegisterDefaultGenericSecretBackends()) {
            for (VaultKeyValueBackendPropertiesSupport keyValueBackend : keyValueBackends) {
                if (!keyValueBackend.isEnabled()) continue;
                List<String> contexts = KeyValueSecretBackendMetadata.buildContexts(keyValueBackend, Arrays.asList(this.applicationContext.getEnvironment().getActiveProfiles()));
                for (String context : contexts) {
                    secretBackendConfigurer.add(GenericSecretBackendMetadata.create(keyValueBackend.getBackend(), context));
                }
            }
            backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
            backendAccessors.forEach(secretBackendConfigurer::add);
        }
        if (secretBackendConfigurer.isRegisterDefaultDiscoveredSecretBackends()) {
            backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
            backendAccessors.forEach(secretBackendConfigurer::add);
        }
        return secretBackendConfigurer;
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public SecretLeaseContainer secretLeaseContainer(VaultOperations vaultOperations, VaultBootstrapConfiguration.TaskSchedulerWrapper taskSchedulerWrapper) {
        return new SecretLeaseContainer(vaultOperations, (TaskScheduler)taskSchedulerWrapper.getTaskScheduler());
    }
}

