/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationStepsOperator;
import org.springframework.vault.authentication.CachingVaultTokenSupplier;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.client.ReactiveVaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.config.ClientHttpConnectorFactory;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultTemplate;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Flux.class, WebClient.class, ReactiveVaultOperations.class})
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFF5)
public class ReactiveVaultBootstrapConfiguration {
    private final VaultProperties vaultProperties;
    private final VaultEndpoint vaultEndpoint;
    private final ClientHttpConnector clientHttpConnector;

    public ReactiveVaultBootstrapConfiguration(VaultProperties vaultProperties) {
        this.vaultProperties = vaultProperties;
        this.vaultEndpoint = ReactiveVaultBootstrapConfiguration.getVaultEndpoint(vaultProperties);
        this.clientHttpConnector = ReactiveVaultBootstrapConfiguration.createConnector(this.vaultProperties);
    }

    private static VaultEndpoint getVaultEndpoint(VaultProperties vaultProperties) {
        if (StringUtils.hasText((String)vaultProperties.getUri())) {
            return VaultEndpoint.from((URI)URI.create(vaultProperties.getUri()));
        }
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(vaultProperties.getHost());
        vaultEndpoint.setPort(vaultProperties.getPort());
        vaultEndpoint.setScheme(vaultProperties.getScheme());
        return vaultEndpoint;
    }

    private static ClientHttpConnector createConnector(VaultProperties vaultProperties) {
        SslConfiguration sslConfiguration;
        ClientOptions clientOptions = new ClientOptions(Duration.ofMillis(vaultProperties.getConnectionTimeout()), Duration.ofMillis(vaultProperties.getReadTimeout()));
        VaultProperties.Ssl ssl = vaultProperties.getSsl();
        if (ssl != null) {
            SslConfiguration.KeyStoreConfiguration keyStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
            SslConfiguration.KeyStoreConfiguration trustStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
            if (ssl.getKeyStore() != null) {
                keyStore = StringUtils.hasText((String)ssl.getKeyStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore(), (char[])ssl.getKeyStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore());
            }
            if (ssl.getTrustStore() != null) {
                trustStore = StringUtils.hasText((String)ssl.getTrustStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore(), (char[])ssl.getTrustStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore());
            }
            sslConfiguration = new SslConfiguration(keyStore, trustStore);
        } else {
            sslConfiguration = SslConfiguration.unconfigured();
        }
        return ClientHttpConnectorFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveVaultTemplate reactiveVaultTemplate(VaultTokenSupplier tokenSupplier) {
        return new ReactiveVaultTemplate(this.vaultEndpoint, this.clientHttpConnector, tokenSupplier);
    }

    @Bean
    @ConditionalOnMissingBean(value={VaultTokenSupplier.class})
    public VaultTokenSupplier vaultTokenSupplier(AuthenticationStepsFactory factory) {
        WebClient webClient = ReactiveVaultClients.createWebClient((VaultEndpoint)this.vaultEndpoint, (ClientHttpConnector)this.clientHttpConnector);
        AuthenticationStepsOperator operator = new AuthenticationStepsOperator(factory.getAuthenticationSteps(), webClient);
        return CachingVaultTokenSupplier.of((VaultTokenSupplier)operator);
    }
}

