/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.rabbitmq;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.PropertyNameTransformer;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.rabbitmq.VaultRabbitMqProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={VaultRabbitMqProperties.class})
public class VaultConfigRabbitMqBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RabbitMqSecretBackendMetadataFactory rabbitMqSecureBackendAccessorFactory() {
        return new RabbitMqSecretBackendMetadataFactory();
    }

    public static class RabbitMqSecretBackendMetadataFactory
    implements SecretBackendMetadataFactory<VaultRabbitMqProperties> {
        static SecretBackendMetadata forRabbitMq(final VaultRabbitMqProperties properties) {
            Assert.notNull((Object)properties, (String)"VaultRabbitMqProperties must not be null");
            final PropertyNameTransformer transformer = new PropertyNameTransformer();
            transformer.addKeyTransformation("username", properties.getUsernameProperty());
            transformer.addKeyTransformation("password", properties.getPasswordProperty());
            return new SecretBackendMetadata(){

                public String getName() {
                    return String.format("%s with Role %s", properties.getBackend(), properties.getRole());
                }

                public String getPath() {
                    return String.format("%s/creds/%s", properties.getBackend(), properties.getRole());
                }

                public PropertyTransformer getPropertyTransformer() {
                    return transformer;
                }

                public Map<String, String> getVariables() {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("backend", properties.getBackend());
                    variables.put("key", String.format("creds/%s", properties.getRole()));
                    return variables;
                }
            };
        }

        public SecretBackendMetadata createMetadata(VaultRabbitMqProperties backendDescriptor) {
            return RabbitMqSecretBackendMetadataFactory.forRabbitMq(backendDescriptor);
        }

        public boolean supports(VaultSecretBackendDescriptor backendDescriptor) {
            return backendDescriptor instanceof VaultRabbitMqProperties;
        }
    }
}

