/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.consul;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.vault.config.consul.ConsulBackendMetadata;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class VaultConfigConsulAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulSecretRebindListener consulSecretRebindListener(ConfigurationPropertiesRebinder rebinder, ConfigurableApplicationContext context) {
        ApplicationContext parent = context.getParent();
        if (parent != null) {
            context = (ConfigurableApplicationContext)parent;
        }
        return new ConsulSecretRebindListener(rebinder, context);
    }

    public static class ConsulSecretRebindListener
    implements ApplicationListener<ConsulBackendMetadata.RebindConsulEvent> {
        private final Log log = LogFactory.getLog(this.getClass());
        private final ConfigurationPropertiesRebinder rebinder;

        public ConsulSecretRebindListener(ConfigurationPropertiesRebinder rebinder, ConfigurableApplicationContext context) {
            this.rebinder = rebinder;
            context.addApplicationListener((ApplicationListener)this);
        }

        public void onApplicationEvent(ConsulBackendMetadata.RebindConsulEvent event) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"received RebindConsulEvent");
            }
            this.rebind("consulDiscoveryProperties");
            this.rebind("consulConfigProperties");
        }

        private void rebind(String bean) {
            boolean success = this.rebinder.rebind(bean);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)String.format("Attempted to rebind Consul bean '%s' with updated ACL token from vault, success: %s", bean, success));
            }
        }
    }
}

