/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.listener.ItemWriteListener;
import org.springframework.batch.item.Chunk;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingItemWriteListener
implements ItemWriteListener,
Ordered {
    private static final Log logger = LogFactory.getLog(EventEmittingItemWriteListener.class);
    private int order = Integer.MAX_VALUE;
    private final MessagePublisher<String> messagePublisher;
    private TaskEventProperties properties;

    public EventEmittingItemWriteListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.messagePublisher = messagePublisher;
        this.properties = properties;
    }

    public EventEmittingItemWriteListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void beforeWrite(Chunk items) {
        this.messagePublisher.publish(this.properties.getItemWriteEventBindingName(), items.size() + " items to be written.");
    }

    public void afterWrite(Chunk items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing afterWrite: " + String.valueOf(items)));
        }
        this.messagePublisher.publish(this.properties.getItemWriteEventBindingName(), items.size() + " items have been written.");
    }

    public void onWriteError(Exception exception, Chunk items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onWriteError: " + exception.getMessage()), (Throwable)exception);
        }
        String payload = "Exception while " + items.size() + " items are attempted to be written.";
        this.messagePublisher.publishWithThrowableHeader(this.properties.getItemWriteEventBindingName(), payload, exception.getMessage());
    }

    public int getOrder() {
        return this.order;
    }
}

