/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.listener.StepExecutionListener;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.StepExecutionEvent;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingStepExecutionListener
implements StepExecutionListener,
Ordered {
    private final MessagePublisher<StepExecutionEvent> messagePublisher;
    private int order = Integer.MAX_VALUE;
    private TaskEventProperties properties;

    public EventEmittingStepExecutionListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.messagePublisher = messagePublisher;
        this.properties = properties;
    }

    public EventEmittingStepExecutionListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.messagePublisher.publish(this.properties.getStepExecutionEventBindingName(), new StepExecutionEvent(stepExecution));
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        this.messagePublisher.publish(this.properties.getStepExecutionEventBindingName(), new StepExecutionEvent(stepExecution));
        return stepExecution.getExitStatus();
    }

    public int getOrder() {
        return this.order;
    }
}

