/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.listener.ItemProcessListener;
import org.springframework.batch.core.listener.ItemReadListener;
import org.springframework.batch.core.listener.ItemWriteListener;
import org.springframework.batch.core.listener.JobExecutionListener;
import org.springframework.batch.core.listener.SkipListener;
import org.springframework.batch.core.listener.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.cloud.task.batch.listener.EventEmittingChunkListener;
import org.springframework.cloud.task.batch.listener.EventEmittingItemProcessListener;
import org.springframework.cloud.task.batch.listener.EventEmittingItemReadListener;
import org.springframework.cloud.task.batch.listener.EventEmittingItemWriteListener;
import org.springframework.cloud.task.batch.listener.EventEmittingJobExecutionListener;
import org.springframework.cloud.task.batch.listener.EventEmittingSkipListener;
import org.springframework.cloud.task.batch.listener.EventEmittingStepExecutionListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskBatchEventListenerBeanPostProcessor;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.cloud.task.configuration.SimpleTaskAutoConfiguration;
import org.springframework.cloud.task.listener.TaskLifecycleListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfiguration(after={SimpleTaskAutoConfiguration.class})
@ConditionalOnClass(value={Job.class})
@ConditionalOnBean(value={Job.class, TaskLifecycleListener.class})
@ConditionalOnProperty(prefix="spring.cloud.task.batch.events", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class BatchEventAutoConfiguration {
    public static final String JOB_EXECUTION_EVENTS_LISTENER = "jobExecutionEventsListener";
    public static final String CHUNK_EVENTS_LISTENER = "chunkEventsListener";
    public static final String STEP_EXECUTION_EVENTS_LISTENER = "stepExecutionEventsListener";
    public static final String ITEM_READ_EVENTS_LISTENER = "itemReadEventsListener";
    public static final String ITEM_WRITE_EVENTS_LISTENER = "itemWriteEventsListener";
    public static final String ITEM_PROCESS_EVENTS_LISTENER = "itemProcessEventsListener";
    public static final String SKIP_EVENTS_LISTENER = "skipEventsListener";

    @Bean
    @ConditionalOnMissingBean
    public static TaskBatchEventListenerBeanPostProcessor batchTaskEventListenerBeanPostProcessor() {
        return new TaskBatchEventListenerBeanPostProcessor();
    }

    @AutoConfiguration
    @ConditionalOnClass(value={StreamBridge.class})
    @EnableConfigurationProperties(value={TaskEventProperties.class})
    @ConditionalOnMissingBean(name={"jobExecutionEventsListener"})
    @ConditionalOnExpression(value="T(org.springframework.util.StringUtils).isEmpty('${spring.batch.job.jobName:}')")
    public static class JobExecutionListenerConfiguration {
        @Autowired
        private TaskEventProperties taskEventProperties;

        @Bean
        @Lazy
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public JobExecutionListener jobExecutionEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingJobExecutionListener(messagePublisher, this.taskEventProperties.getJobExecutionOrder(), properties);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.step-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public StepExecutionListener stepExecutionEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingStepExecutionListener(messagePublisher, this.taskEventProperties.getStepExecutionOrder(), properties);
        }

        @Bean
        @Lazy
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.chunk", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public EventEmittingChunkListener chunkEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingChunkListener(messagePublisher, this.taskEventProperties.getChunkOrder(), properties);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.item-read", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ItemReadListener itemReadEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingItemReadListener(messagePublisher, this.taskEventProperties.getItemReadOrder(), properties);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.item-write", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ItemWriteListener itemWriteEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingItemWriteListener(messagePublisher, this.taskEventProperties.getItemWriteOrder(), properties);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.item-process", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ItemProcessListener itemProcessEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingItemProcessListener(messagePublisher, this.taskEventProperties.getItemProcessOrder(), properties);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.skip", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public SkipListener skipEventsListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
            return new EventEmittingSkipListener(messagePublisher, this.taskEventProperties.getItemProcessOrder(), properties);
        }

        @Bean
        public MessagePublisher messagePublisher(StreamBridge streamBridge) {
            return new MessagePublisher(streamBridge);
        }
    }
}

