/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.cloud.task.batch.listener.support.JobParameterEvent;

public class JobParametersEvent {
    private final Map<String, JobParameterEvent> parameters = new LinkedHashMap<String, JobParameterEvent>();

    public JobParametersEvent() {
    }

    public JobParametersEvent(Map<String, JobParameter> jobParameters) {
        for (Map.Entry<String, JobParameter> entry : jobParameters.entrySet()) {
            if (entry.getValue().getValue() instanceof String) {
                this.parameters.put(entry.getKey(), new JobParameterEvent(entry.getValue()));
                continue;
            }
            if (entry.getValue().getValue() instanceof Long) {
                this.parameters.put(entry.getKey(), new JobParameterEvent(entry.getValue()));
                continue;
            }
            if (entry.getValue().getValue() instanceof Date) {
                this.parameters.put(entry.getKey(), new JobParameterEvent(entry.getValue()));
                continue;
            }
            if (!(entry.getValue().getValue() instanceof Double)) continue;
            this.parameters.put(entry.getKey(), new JobParameterEvent(entry.getValue()));
        }
    }

    public Long getLong(String key) {
        if (!this.parameters.containsKey(key)) {
            return 0L;
        }
        Object value = this.parameters.get(key).getValue();
        return value == null ? 0L : (Long)value;
    }

    public Long getLong(String key, long defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLong(key);
        }
        return defaultValue;
    }

    public String getString(String key) {
        JobParameterEvent value = this.parameters.get(key);
        return value == null ? null : value.toString();
    }

    public String getString(String key, String defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }

    public Double getDouble(String key) {
        if (!this.parameters.containsKey(key)) {
            return 0.0;
        }
        Double value = (Double)this.parameters.get(key).getValue();
        return value == null ? 0.0 : value;
    }

    public Double getDouble(String key, double defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        if (this.parameters.containsKey(key)) {
            return (Date)this.parameters.get(key).getValue();
        }
        return defaultValue;
    }

    public Map<String, JobParameterEvent> getParameters() {
        return new LinkedHashMap<String, JobParameterEvent>(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParametersEvent)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JobParametersEvent rhs = (JobParametersEvent)obj;
        return this.parameters.equals(rhs.parameters);
    }

    public int hashCode() {
        return 17 + 23 * this.parameters.hashCode();
    }

    public String toString() {
        return this.parameters.toString();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, JobParameterEvent> param : this.parameters.entrySet()) {
            if (param.getValue() == null) continue;
            props.put(param.getKey(), param.getValue().toString());
        }
        return props;
    }
}

