/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.partition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.poller.DirectPoller;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.task.batch.partition.CommandLineArgsProvider;
import org.springframework.cloud.task.batch.partition.EnvironmentVariablesProvider;
import org.springframework.cloud.task.batch.partition.SimpleCommandLineArgsProvider;
import org.springframework.cloud.task.batch.partition.SimpleEnvironmentVariablesProvider;
import org.springframework.cloud.task.listener.annotation.BeforeTask;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DeployerPartitionHandler
implements PartitionHandler,
EnvironmentAware,
InitializingBean {
    public static final String SPRING_CLOUD_TASK_JOB_EXECUTION_ID = "spring.cloud.task.job-execution-id";
    public static final String SPRING_CLOUD_TASK_STEP_EXECUTION_ID = "spring.cloud.task.step-execution-id";
    public static final String SPRING_CLOUD_TASK_STEP_NAME = "spring.cloud.task.step-name";
    public static final String SPRING_CLOUD_TASK_PARENT_EXECUTION_ID = "spring.cloud.task.parentExecutionId";
    public static final String SPRING_CLOUD_TASK_EXECUTION_ID = "spring.cloud.task.executionid";
    public static final String SPRING_CLOUD_TASK_NAME = "spring.cloud.task.name";
    private static final long DEFAULT_POLL_INTERVAL = 10000L;
    private int maxWorkers = -1;
    private int gridSize = 1;
    private int currentWorkers = 0;
    private TaskLauncher taskLauncher;
    private JobExplorer jobExplorer;
    private TaskExecution taskExecution;
    private Resource resource;
    private String stepName;
    private Log logger = LogFactory.getLog(DeployerPartitionHandler.class);
    private long pollInterval = 10000L;
    private long timeout = -1L;
    private Environment environment;
    private Map<String, String> deploymentProperties;
    private EnvironmentVariablesProvider environmentVariablesProvider;
    private String applicationName;
    private CommandLineArgsProvider commandLineArgsProvider;
    private boolean defaultArgsAsEnvironmentVars = false;
    @Autowired
    private TaskRepository taskRepository;

    @Deprecated
    public DeployerPartitionHandler(TaskLauncher taskLauncher, JobExplorer jobExplorer, Resource resource, String stepName) {
        Assert.notNull((Object)taskLauncher, (String)"A taskLauncher is required");
        Assert.notNull((Object)jobExplorer, (String)"A jobExplorer is required");
        Assert.notNull((Object)resource, (String)"A resource is required");
        Assert.hasText((String)stepName, (String)"A step name is required");
        this.taskLauncher = taskLauncher;
        this.jobExplorer = jobExplorer;
        this.resource = resource;
        this.stepName = stepName;
    }

    public DeployerPartitionHandler(TaskLauncher taskLauncher, JobExplorer jobExplorer, Resource resource, String stepName, TaskRepository taskRepository) {
        Assert.notNull((Object)taskLauncher, (String)"A taskLauncher is required");
        Assert.notNull((Object)jobExplorer, (String)"A jobExplorer is required");
        Assert.notNull((Object)resource, (String)"A resource is required");
        Assert.hasText((String)stepName, (String)"A step name is required");
        Assert.notNull((Object)taskRepository, (String)"A TaskRepository is required");
        this.taskLauncher = taskLauncher;
        this.jobExplorer = jobExplorer;
        this.resource = resource;
        this.stepName = stepName;
        this.taskRepository = taskRepository;
    }

    public void setEnvironmentVariablesProvider(EnvironmentVariablesProvider environmentVariablesProvider) {
        this.environmentVariablesProvider = environmentVariablesProvider;
    }

    public void setDefaultArgsAsEnvironmentVars(boolean defaultArgsAsEnvironmentVars) {
        this.defaultArgsAsEnvironmentVars = defaultArgsAsEnvironmentVars;
    }

    public void setCommandLineArgsProvider(CommandLineArgsProvider commandLineArgsProvider) {
        this.commandLineArgsProvider = commandLineArgsProvider;
    }

    public void setMaxWorkers(int maxWorkers) {
        Assert.isTrue((maxWorkers != 0 ? 1 : 0) != 0, (String)"maxWorkers cannot be 0");
        this.maxWorkers = maxWorkers;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setDeploymentProperties(Map<String, String> deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @BeforeTask
    public void beforeTask(TaskExecution taskExecution) {
        this.taskExecution = taskExecution;
        if (this.commandLineArgsProvider == null) {
            SimpleCommandLineArgsProvider provider = new SimpleCommandLineArgsProvider(taskExecution);
            this.commandLineArgsProvider = provider;
        }
    }

    public Collection<StepExecution> handle(StepExecutionSplitter stepSplitter, StepExecution stepExecution) throws Exception {
        Set tempCandidates = stepSplitter.split(stepExecution, this.gridSize);
        HashSet<StepExecution> candidates = new HashSet<StepExecution>(tempCandidates.size());
        candidates.addAll(tempCandidates);
        int partitions = candidates.size();
        this.logger.debug((Object)String.format("%s partitions were returned", partitions));
        HashSet<StepExecution> executed = new HashSet<StepExecution>(candidates.size());
        if (CollectionUtils.isEmpty(candidates)) {
            return Collections.emptySet();
        }
        this.launchWorkers(candidates, executed);
        candidates.removeAll(executed);
        return this.pollReplies(stepExecution, executed, candidates, partitions);
    }

    private void launchWorkers(Set<StepExecution> candidates, Set<StepExecution> executed) {
        for (StepExecution execution : candidates) {
            if (this.currentWorkers >= this.maxWorkers && this.maxWorkers >= 0) continue;
            this.launchWorker(execution);
            ++this.currentWorkers;
            executed.add(execution);
        }
    }

    private void launchWorker(StepExecution workerStepExecution) {
        ArrayList<String> arguments = new ArrayList<String>();
        ExecutionContext copyContext = new ExecutionContext(workerStepExecution.getExecutionContext());
        arguments.addAll(this.commandLineArgsProvider.getCommandLineArgs(copyContext));
        TaskExecution partitionTaskExecution = null;
        if (this.taskRepository != null) {
            partitionTaskExecution = this.taskRepository.createTaskExecution();
        } else {
            this.logger.warn((Object)"TaskRepository was not set so external execution id will not be recorded.");
        }
        if (!this.defaultArgsAsEnvironmentVars) {
            arguments.add(this.formatArgument(SPRING_CLOUD_TASK_JOB_EXECUTION_ID, String.valueOf(workerStepExecution.getJobExecution().getId())));
            arguments.add(this.formatArgument(SPRING_CLOUD_TASK_STEP_EXECUTION_ID, String.valueOf(workerStepExecution.getId())));
            arguments.add(this.formatArgument(SPRING_CLOUD_TASK_STEP_NAME, this.stepName));
            arguments.add(this.formatArgument(SPRING_CLOUD_TASK_NAME, String.format("%s_%s_%s", this.taskExecution.getTaskName(), workerStepExecution.getJobExecution().getJobInstance().getJobName(), workerStepExecution.getStepName())));
            arguments.add(this.formatArgument(SPRING_CLOUD_TASK_PARENT_EXECUTION_ID, String.valueOf(this.taskExecution.getExecutionId())));
            if (partitionTaskExecution != null) {
                arguments.add(this.formatArgument(SPRING_CLOUD_TASK_EXECUTION_ID, String.valueOf(partitionTaskExecution.getExecutionId())));
            }
        }
        copyContext = new ExecutionContext(workerStepExecution.getExecutionContext());
        Map<String, String> environmentVariables = this.environmentVariablesProvider.getEnvironmentVariables(copyContext);
        if (this.defaultArgsAsEnvironmentVars) {
            environmentVariables.put(SPRING_CLOUD_TASK_JOB_EXECUTION_ID, String.valueOf(workerStepExecution.getJobExecution().getId()));
            environmentVariables.put(SPRING_CLOUD_TASK_STEP_EXECUTION_ID, String.valueOf(workerStepExecution.getId()));
            environmentVariables.put(SPRING_CLOUD_TASK_STEP_NAME, this.stepName);
            environmentVariables.put(SPRING_CLOUD_TASK_NAME, String.format("%s_%s_%s", this.taskExecution.getTaskName(), workerStepExecution.getJobExecution().getJobInstance().getJobName(), workerStepExecution.getStepName()));
            environmentVariables.put(SPRING_CLOUD_TASK_PARENT_EXECUTION_ID, String.valueOf(this.taskExecution.getExecutionId()));
            environmentVariables.put(SPRING_CLOUD_TASK_EXECUTION_ID, String.valueOf(partitionTaskExecution.getExecutionId()));
        }
        AppDefinition definition = new AppDefinition(this.resolveApplicationName(), environmentVariables);
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.resource, this.deploymentProperties, arguments);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Requesting the launch of the following application: " + request));
        }
        String externalExecutionId = this.taskLauncher.launch(request);
        if (this.taskRepository != null) {
            this.taskRepository.updateExternalExecutionId(partitionTaskExecution.getExecutionId(), externalExecutionId);
        }
    }

    private String resolveApplicationName() {
        if (StringUtils.hasText((String)this.applicationName)) {
            return this.applicationName;
        }
        return this.taskExecution.getTaskName();
    }

    private String formatArgument(String key, String value) {
        return String.format("--%s=%s", key, value);
    }

    private Collection<StepExecution> pollReplies(final StepExecution masterStepExecution, final Set<StepExecution> executed, final Set<StepExecution> candidates, final int size) throws Exception {
        final ArrayList result = new ArrayList(executed.size());
        Callable<Collection<StepExecution>> callback = new Callable<Collection<StepExecution>>(){

            @Override
            public Collection<StepExecution> call() throws Exception {
                HashSet newExecuted = new HashSet();
                for (StepExecution curStepExecution : executed) {
                    StepExecution partitionStepExecution;
                    BatchStatus batchStatus;
                    if (result.contains(curStepExecution) || (batchStatus = (partitionStepExecution = DeployerPartitionHandler.this.jobExplorer.getStepExecution(masterStepExecution.getJobExecutionId(), curStepExecution.getId())).getStatus()) == null || !DeployerPartitionHandler.this.isComplete(batchStatus)) continue;
                    result.add(partitionStepExecution);
                    DeployerPartitionHandler.this.currentWorkers--;
                    if (candidates.isEmpty()) continue;
                    DeployerPartitionHandler.this.launchWorkers(candidates, newExecuted);
                    candidates.removeAll(newExecuted);
                }
                executed.addAll(newExecuted);
                if (result.size() == size) {
                    return result;
                }
                return null;
            }
        };
        DirectPoller poller = new DirectPoller(this.pollInterval);
        Future resultsFuture = poller.poll((Callable)callback);
        if (this.timeout >= 0L) {
            return (Collection)resultsFuture.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        return (Collection)resultsFuture.get();
    }

    private boolean isComplete(BatchStatus status) {
        return status.equals((Object)BatchStatus.COMPLETED) || status.isGreaterThan(BatchStatus.STARTED);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.environmentVariablesProvider == null) {
            this.environmentVariablesProvider = new SimpleEnvironmentVariablesProvider(this.environment);
        }
    }
}

