/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.batch.handler.TaskJobLauncherCommandLineRunner;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskJobLauncherCommandLineRunnerFactoryBean
implements FactoryBean<TaskJobLauncherCommandLineRunner> {
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;
    private List<Job> jobs;
    private String jobNames;
    private JobRegistry jobRegistry;
    private Integer order = 0;

    public TaskJobLauncherCommandLineRunnerFactoryBean(JobLauncher jobLauncher, JobExplorer jobExplorer, List<Job> jobs, String jobNames, JobRegistry jobRegistry) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        Assert.notEmpty(jobs, (String)"jobs must not be null nor empty");
        this.jobs = jobs;
        this.jobNames = jobNames;
        this.jobRegistry = jobRegistry;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public TaskJobLauncherCommandLineRunner getObject() throws Exception {
        TaskJobLauncherCommandLineRunner taskJobLauncherCommandLineRunner = new TaskJobLauncherCommandLineRunner(this.jobLauncher, this.jobExplorer);
        taskJobLauncherCommandLineRunner.setJobs(this.jobs);
        if (StringUtils.hasText((String)this.jobNames)) {
            taskJobLauncherCommandLineRunner.setJobNames(this.jobNames);
        }
        taskJobLauncherCommandLineRunner.setJobRegistry(this.jobRegistry);
        if (this.order != null) {
            taskJobLauncherCommandLineRunner.setOrder(this.order);
        }
        return taskJobLauncherCommandLineRunner;
    }

    public Class<?> getObjectType() {
        return TaskJobLauncherCommandLineRunner.class;
    }
}

