/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class ObjectStringMessageConverter
extends AbstractMessageConverter {
    public ObjectStringMessageConverter() {
        super(new MimeType("text", "*", StandardCharsets.UTF_8));
        this.setStrictContentTypeMatch(true);
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supportsMimeType(message.getHeaders());
    }

    protected boolean supportsMimeType(@Nullable MessageHeaders headers) {
        MimeType mimeType = this.getMimeType(headers);
        if (mimeType != null) {
            for (MimeType current : this.getSupportedMimeTypes()) {
                if (!current.getType().equals(mimeType.getType())) continue;
                return true;
            }
        }
        return super.supportsMimeType(headers);
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        if (message.getPayload() != null) {
            Object object = message.getPayload();
            if (object instanceof byte[]) {
                byte[] payloadAsBytes = (byte[])object;
                if (byte[].class.isAssignableFrom(targetClass)) {
                    return message.getPayload();
                }
                return new String(payloadAsBytes, StandardCharsets.UTF_8);
            }
            object = message.getPayload();
            if (object instanceof Collection) {
                Collection payloadAsCollection = (Collection)object;
                return payloadAsCollection.stream().map(value -> {
                    if (byte[].class.isAssignableFrom(targetClass)) {
                        return value;
                    }
                    if (value instanceof byte[]) {
                        byte[] valueAsBytes = (byte[])value;
                        return new String(valueAsBytes, StandardCharsets.UTF_8);
                    }
                    return value;
                }).collect(Collectors.toList());
            }
            if (byte[].class.isAssignableFrom(targetClass)) {
                return message.getPayload().toString().getBytes(StandardCharsets.UTF_8);
            }
            return message.getPayload();
        }
        return null;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        if (payload != null) {
            if (payload instanceof byte[]) {
                return payload;
            }
            return payload.toString().getBytes();
        }
        return null;
    }
}

