/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.Environment;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.stream")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class BindingServiceProperties
implements ApplicationContextAware,
InitializingBean {
    private static final int DEFAULT_BINDING_RETRY_INTERVAL = 30;
    @Deprecated
    private String source;
    private String inputBindings;
    private String outputBindings;
    @Value(value="${INSTANCE_INDEX:${CF_INSTANCE_INDEX:0}}")
    private int instanceIndex;
    private List<Integer> instanceIndexList = new ArrayList<Integer>();
    private int instanceCount = 1;
    private Map<String, BindingProperties> bindings = new TreeMap<String, BindingProperties>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, BinderProperties> binders = new HashMap<String, BinderProperties>();
    private String defaultBinder;
    private int dynamicDestinationCacheSize = 10;
    private int bindingRetryInterval = 30;
    private ConfigurableApplicationContext applicationContext = new GenericApplicationContext();
    private ConversionService conversionService;

    public Map<String, BindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, BindingProperties> bindings) {
        this.bindings.putAll(bindings);
    }

    public Map<String, BinderProperties> getBinders() {
        return this.binders;
    }

    public void setBinders(Map<String, BinderProperties> binders) {
        this.binders = binders;
    }

    public String getDefaultBinder() {
        return this.defaultBinder;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(int instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public List<Integer> getInstanceIndexList() {
        return this.instanceIndexList;
    }

    public void setInstanceIndexList(List<Integer> instanceIndexList) {
        this.instanceIndexList = instanceIndexList;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        GenericConversionService cs = (GenericConversionService)IntegrationUtils.getConversionService((BeanFactory)this.applicationContext.getBeanFactory());
        if (this.applicationContext.containsBean("spelConverter")) {
            Converter converter = (Converter)this.applicationContext.getBean("spelConverter");
            cs.addConverter(converter);
        }
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.conversionService == null) {
            this.conversionService = (ConversionService)this.applicationContext.getBean("integrationConversionService", ConversionService.class);
        }
    }

    public String getBinderType(String binderName) {
        BinderProperties bp = this.binders.get(binderName);
        return bp != null ? bp.getType() : this.bindings.keySet().iterator().next();
    }

    public String getBinder(String bindingName) {
        return this.getBindingProperties(bindingName).getBinder();
    }

    public Map<String, Object> asMapProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("instanceIndex", String.valueOf(this.getInstanceIndex()));
        properties.put("instanceCount", String.valueOf(this.getInstanceCount()));
        properties.put("defaultBinder", this.getDefaultBinder());
        for (Map.Entry<String, BindingProperties> entry : this.bindings.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().toString());
        }
        for (Map.Entry<String, Object> entry : this.binders.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public ConsumerProperties getConsumerProperties(String inputBindingName) {
        Assert.notNull((Object)inputBindingName, (String)"The input binding name cannot be null");
        BindingProperties bindingProperties = this.getBindingProperties(inputBindingName);
        ConsumerProperties consumerProperties = bindingProperties.getConsumer();
        if (consumerProperties == null) {
            consumerProperties = new ConsumerProperties();
            bindingProperties.setConsumer(consumerProperties);
        }
        if (consumerProperties.getInstanceCount() < 0) {
            consumerProperties.setInstanceCount(this.instanceCount);
        }
        if (consumerProperties.getInstanceIndex() < 0) {
            consumerProperties.setInstanceIndex(this.instanceIndex);
        }
        if (consumerProperties.getInstanceIndexList() == null) {
            consumerProperties.setInstanceIndexList(this.instanceIndexList);
        }
        return consumerProperties;
    }

    public ProducerProperties getProducerProperties(String outputBindingName) {
        Assert.notNull((Object)outputBindingName, (String)"The output binding name cannot be null");
        BindingProperties bindingProperties = this.getBindingProperties(outputBindingName);
        ProducerProperties producerProperties = bindingProperties.getProducer();
        if (producerProperties == null) {
            producerProperties = new ProducerProperties();
            bindingProperties.setProducer(producerProperties);
        }
        return producerProperties;
    }

    public BindingProperties getBindingProperties(String bindingName) {
        this.bindIfNecessary(bindingName);
        BindingProperties bindingProperties = this.bindings.get(bindingName);
        if (bindingProperties.getDestination() == null) {
            bindingProperties.setDestination(bindingName);
        }
        return bindingProperties;
    }

    public String getGroup(String bindingName) {
        return this.getBindingProperties(bindingName).getGroup();
    }

    public String getBindingDestination(String bindingName) {
        return this.getBindingProperties(bindingName).getDestination();
    }

    public int getBindingRetryInterval() {
        return this.bindingRetryInterval;
    }

    public void setBindingRetryInterval(int bindingRetryInterval) {
        this.bindingRetryInterval = bindingRetryInterval;
    }

    @Deprecated
    public String getSource() {
        return this.source;
    }

    @Deprecated
    public void setSource(String source) {
        this.source = source;
        this.outputBindings = source;
    }

    public void updateProducerProperties(String bindingName, ProducerProperties producerProperties) {
        if (this.bindings.containsKey(bindingName)) {
            this.bindings.get(bindingName).setProducer(producerProperties);
        }
    }

    public int getDynamicDestinationCacheSize() {
        return this.dynamicDestinationCacheSize;
    }

    public void setDynamicDestinationCacheSize(int dynamicDestinationCacheSize) {
        this.dynamicDestinationCacheSize = dynamicDestinationCacheSize;
    }

    public String getInputBindings() {
        return this.inputBindings;
    }

    public void setInputBindings(String inputBindings) {
        this.inputBindings = inputBindings;
    }

    public String getOutputBindings() {
        return this.outputBindings;
    }

    public void setOutputBindings(String outputBindings) {
        Assert.state((!StringUtils.hasText((String)this.source) ? 1 : 0) != 0, (String)"Setting 'source' and 'output-binding' is not allowed because 'source' is deprecated in favor of 'output-binding'.");
        this.outputBindings = outputBindings;
    }

    private void bindIfNecessary(String bindingName) {
        if (!this.bindings.containsKey(bindingName)) {
            this.bindToDefault(bindingName);
        }
    }

    private void bindToDefault(String binding) {
        BindingProperties bindingPropertiesTarget = new BindingProperties();
        Binder binder = new Binder(ConfigurationPropertySources.get((Environment)this.applicationContext.getEnvironment()), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Environment)this.applicationContext.getEnvironment()), IntegrationUtils.getConversionService((BeanFactory)this.applicationContext.getBeanFactory()), null);
        binder.bind("spring.cloud.stream.default", Bindable.ofInstance((Object)bindingPropertiesTarget));
        this.bindings.put(binding, bindingPropertiesTarget);
    }
}

