/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;

public abstract class AbstractBindingLifecycle
implements SmartLifecycle {
    final BindingService bindingService;
    private final Map<String, Bindable> bindables;
    @Autowired
    private ApplicationContext context;
    private volatile boolean running;

    AbstractBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        this.bindingService = bindingService;
        this.bindables = bindables;
    }

    public void start() {
        if (!this.running) {
            if (this.context != null) {
                this.bindables.putAll(this.context.getBeansOfType(Bindable.class));
            }
            this.bindables.values().forEach(this::doStartWithBindable);
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            if (this.context != null) {
                this.bindables.putAll(this.context.getBeansOfType(Bindable.class));
            }
            this.bindables.values().forEach(this::doStopWithBindable);
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    abstract void doStartWithBindable(Bindable var1);

    abstract void doStopWithBindable(Bindable var1);
}

