/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.stream.binder.BinderChildContextInitializer;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderCustomizer;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.BindingsLifecycleController;
import org.springframework.cloud.stream.binding.ContextStartAfterRefreshListener;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingHandlerAdvise;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.SpelExpressionConverterConfiguration;
import org.springframework.cloud.stream.config.SpringIntegrationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={BindingServiceProperties.class, SpringIntegrationProperties.class})
@Import(value={SpelExpressionConverterConfiguration.class})
@Role(value=2)
@ConditionalOnBean(value={BinderTypeRegistry.class}, search=SearchStrategy.CURRENT)
public class BindingServiceConfiguration {
    @Autowired(required=false)
    private Collection<DefaultBinderFactory.Listener> binderFactoryListeners;

    public static Map<String, BinderConfiguration> getBinderConfigurations(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map<String, BinderProperties> declaredBinders = bindingServiceProperties.getBinders();
        boolean defaultCandidatesExist = false;
        Iterator<Map.Entry<String, BinderProperties>> binderPropertiesIterator = declaredBinders.entrySet().iterator();
        while (!defaultCandidatesExist && binderPropertiesIterator.hasNext()) {
            defaultCandidatesExist = binderPropertiesIterator.next().getValue().isDefaultCandidate();
        }
        ArrayList<String> existingBinderConfigurations = new ArrayList<String>();
        for (Map.Entry<String, BinderProperties> entry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = entry.getValue();
            if (binderTypeRegistry.get(entry.getKey()) != null) {
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(entry.getKey(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
                existingBinderConfigurations.add(entry.getKey());
                continue;
            }
            Assert.hasText((String)binderProperties.getType(), (String)("No 'type' property present for custom binder " + entry.getKey()));
            binderConfigurations.put(entry.getKey(), new BinderConfiguration(binderProperties.getType(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
            existingBinderConfigurations.add(entry.getKey());
        }
        for (Map.Entry<String, BinderProperties> entry : binderConfigurations.entrySet()) {
            if (!((BinderConfiguration)((Object)entry.getValue())).isDefaultCandidate()) continue;
            defaultCandidatesExist = true;
        }
        if (!defaultCandidatesExist) {
            for (Map.Entry<String, Object> entry : binderTypeRegistry.getAll().entrySet()) {
                if (existingBinderConfigurations.contains(entry.getKey())) continue;
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(entry.getKey(), new HashMap<String, Object>(), true, true));
            }
        }
        return binderConfigurations;
    }

    @Bean
    public static BeanPostProcessor globalErrorChannelCustomizer() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if ("errorChannel".equals(beanName) && bean instanceof PublishSubscribeChannel) {
                    PublishSubscribeChannel publishSubscribeChannel = (PublishSubscribeChannel)bean;
                    publishSubscribeChannel.setIgnoreFailures(true);
                }
                return bean;
            }
        };
    }

    @Bean
    public BindingHandlerAdvise BindingHandlerAdvise(@Nullable BindingHandlerAdvise.MappingsProvider[] providers) {
        HashMap<ConfigurationPropertyName, ConfigurationPropertyName> additionalMappings = new HashMap<ConfigurationPropertyName, ConfigurationPropertyName>();
        if (!ObjectUtils.isEmpty((Object[])providers)) {
            for (int i = 0; i < providers.length; ++i) {
                BindingHandlerAdvise.MappingsProvider mappingsProvider = providers[i];
                additionalMappings.putAll(mappingsProvider.getDefaultMappings());
            }
        }
        return new BindingHandlerAdvise(additionalMappings);
    }

    @Bean
    @ConditionalOnMissingBean(value={BinderFactory.class})
    public DefaultBinderFactory binderFactory(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties, ObjectProvider<BinderCustomizer> binderCustomizerProvider, BinderChildContextInitializer binderChildContextInitializer) {
        DefaultBinderFactory binderFactory = new DefaultBinderFactory(BindingServiceConfiguration.getBinderConfigurations(binderTypeRegistry, bindingServiceProperties), binderTypeRegistry, (BinderCustomizer)binderCustomizerProvider.getIfUnique());
        binderFactory.setDefaultBinder(bindingServiceProperties.getDefaultBinder());
        binderFactory.setListeners(this.binderFactoryListeners);
        binderChildContextInitializer.setBinderFactory(binderFactory);
        return binderFactory;
    }

    @Bean
    public BinderChildContextInitializer binderChildContextInitializer() {
        return new BinderChildContextInitializer();
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public BindingService bindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory, TaskScheduler taskScheduler, @Nullable ObjectMapper objectMapper) {
        objectMapper = objectMapper == null ? new ObjectMapper() : objectMapper;
        return new BindingService(bindingServiceProperties, binderFactory, taskScheduler, objectMapper);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public OutputBindingLifecycle outputBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        return new OutputBindingLifecycle(bindingService, bindables);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public InputBindingLifecycle inputBindingLifecycle(BindingService bindingService, Map<String, Bindable> bindables) {
        return new InputBindingLifecycle(bindingService, bindables);
    }

    @Bean
    public BindingsLifecycleController bindingsLifecycleController(List<InputBindingLifecycle> inputBindingLifecycles, List<OutputBindingLifecycle> outputBindingsLifecycles) {
        return new BindingsLifecycleController(inputBindingLifecycles, outputBindingsLifecycles);
    }

    @Bean
    @DependsOn(value={"bindingService"})
    public ContextStartAfterRefreshListener contextStartAfterRefreshListener() {
        return new ContextStartAfterRefreshListener();
    }

    @Bean
    public DynamicDestinationsBindable dynamicDestinationsBindable() {
        return new DynamicDestinationsBindable();
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> appListener(final SpringIntegrationProperties springIntegrationProperties) {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                event.getApplicationContext().getBeansOfType(AbstractReplyProducingMessageHandler.class).values().forEach(mh -> mh.addNotPropagatedHeaders(springIntegrationProperties.getMessageHandlerNotPropagatedHeaders()));
            }
        };
    }
}

