/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

public class SubscribableChannelBindingTargetFactory
extends AbstractBindingTargetFactory<SubscribableChannel> {
    private final MessageChannelConfigurer messageChannelConfigurer;
    @Autowired
    private GenericApplicationContext context;

    public SubscribableChannelBindingTargetFactory(MessageChannelConfigurer messageChannelConfigurer) {
        super(SubscribableChannel.class);
        this.messageChannelConfigurer = messageChannelConfigurer;
    }

    @Override
    public SubscribableChannel createInput(String name) {
        Object subscribableChannel = null;
        if (this.context != null && this.context.containsBean(name)) {
            try {
                subscribableChannel = (SubscribableChannel)this.context.getBean(name, SubscribableChannel.class);
            }
            catch (BeanCreationException beanCreationException) {
                // empty catch block
            }
        }
        if (subscribableChannel == null) {
            DirectWithAttributesChannel channel = new DirectWithAttributesChannel();
            channel.setComponentName(name);
            if (this.context != null && !this.context.containsBean(name)) {
                this.context.registerBean(name, DirectWithAttributesChannel.class, () -> channel, new BeanDefinitionCustomizer[0]);
            }
            subscribableChannel = channel;
        }
        if (subscribableChannel instanceof DirectWithAttributesChannel) {
            ((DirectWithAttributesChannel)((Object)subscribableChannel)).setAttribute("type", "input");
            this.messageChannelConfigurer.configureInputChannel((MessageChannel)subscribableChannel, name);
        }
        return subscribableChannel;
    }

    @Override
    public SubscribableChannel createOutput(String name) {
        Object subscribableChannel = null;
        if (this.context != null && this.context.containsBean(name)) {
            try {
                subscribableChannel = (SubscribableChannel)this.context.getBean(name, SubscribableChannel.class);
            }
            catch (BeanCreationException beanCreationException) {
                // empty catch block
            }
        }
        if (subscribableChannel == null) {
            DirectWithAttributesChannel channel = new DirectWithAttributesChannel();
            channel.setComponentName(name);
            if (this.context != null && !this.context.containsBean(name)) {
                this.context.registerBean(name, DirectWithAttributesChannel.class, () -> channel, new BeanDefinitionCustomizer[0]);
            }
            subscribableChannel = channel;
        }
        if (subscribableChannel instanceof DirectWithAttributesChannel) {
            ((DirectWithAttributesChannel)((Object)subscribableChannel)).setAttribute("type", "output");
            this.messageChannelConfigurer.configureOutputChannel((MessageChannel)subscribableChannel, name);
        }
        return subscribableChannel;
    }
}

