/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class PollerConfigEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log logger = LogFactory.getLog(PollerConfigEnvironmentPostProcessor.class);
    private static final String STREAM_PROPERTY_PREFIX = "spring.cloud.stream.poller.";
    private static final String INTEGRATION_PROPERTY_PREFIX = "spring.integration.poller.";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, String> streamPollerProperties = new HashMap<String, String>();
        String[] pollerPropertySuffixes = new String[]{"fixed-delay", "max-messages-per-poll", "cron", "initial-delay"};
        PropertyMapper map = PropertyMapper.get().alwaysApplying(PropertyMapper.Source::whenHasText);
        for (String pollerPropertySuffix : pollerPropertySuffixes) {
            map.from((Object)environment.getProperty(STREAM_PROPERTY_PREFIX + pollerPropertySuffix)).to(value -> streamPollerProperties.put(INTEGRATION_PROPERTY_PREFIX + pollerPropertySuffix, (String)value));
        }
        if (!streamPollerProperties.isEmpty()) {
            logger.info((Object)"'spring.cloud.stream.poller' properties are deprecated in favor of 'spring.integration.poller' properties.");
        }
        streamPollerProperties.putIfAbsent("spring.integration.poller.fixed-delay", "1s");
        streamPollerProperties.putIfAbsent("spring.integration.poller.max-messages-per-poll", "1");
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource("spring.integration.poller", streamPollerProperties));
    }
}

