/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;

@ConfigurationProperties(value="spring.cloud.stream.poller")
public class DefaultPollerProperties {
    private long fixedDelay = 1000L;
    private long maxMessagesPerPoll = 1L;
    private String cron;
    private int initialDelay = 0;

    public PollerMetadata getPollerMetadata() {
        PollerMetadata pollerMetadata = new PollerMetadata();
        if (this.cron != null) {
            pollerMetadata.setTrigger((Trigger)new CronTrigger(this.cron));
        } else {
            PeriodicTrigger periodicTrigger = new PeriodicTrigger(this.fixedDelay);
            periodicTrigger.setInitialDelay((long)this.initialDelay);
            pollerMetadata.setTrigger((Trigger)periodicTrigger);
        }
        pollerMetadata.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return pollerMetadata;
    }

    public long getFixedDelay() {
        return this.fixedDelay;
    }

    public void setFixedDelay(long fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    public long getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(long maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }
}

