/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.integration.support.utils.IntegrationUtils;

public abstract class AbstractExtendedBindingProperties<C, P, T extends BinderSpecificPropertiesProvider>
implements ExtendedBindingProperties<C, P>,
ApplicationContextAware {
    private final Map<String, T> bindings = new HashMap<String, T>();
    private ConfigurableApplicationContext applicationContext = new GenericApplicationContext();

    public void setBindings(Map<String, T> bindings) {
        this.bindings.putAll(bindings);
    }

    @Override
    public C getExtendedConsumerProperties(String binding) {
        this.bindIfNecessary(binding);
        return (C)((BinderSpecificPropertiesProvider)this.bindings.get(binding)).getConsumer();
    }

    @Override
    public P getExtendedProducerProperties(String binding) {
        this.bindIfNecessary(binding);
        return (P)((BinderSpecificPropertiesProvider)this.bindings.get(binding)).getProducer();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    private void bindIfNecessary(String bindingName) {
        if (!this.bindings.containsKey(bindingName)) {
            this.bindToDefault(bindingName);
        }
    }

    private void bindToDefault(String binding) {
        BinderSpecificPropertiesProvider extendedBindingPropertiesTarget = (BinderSpecificPropertiesProvider)BeanUtils.instantiateClass(this.getExtendedPropertiesEntryClass());
        Binder binder = new Binder(ConfigurationPropertySources.get((Environment)this.applicationContext.getEnvironment()), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Environment)this.applicationContext.getEnvironment()), IntegrationUtils.getConversionService((BeanFactory)this.applicationContext.getBeanFactory()), null);
        binder.bind(this.getDefaultsPrefix(), Bindable.ofInstance((Object)extendedBindingPropertiesTarget));
        this.bindings.put(binding, extendedBindingPropertiesTarget);
    }

    protected Map<String, T> doGetBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }
}

