/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.RequeueCurrentMessageException;
import org.springframework.context.Lifecycle;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.acks.AckUtils;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class DefaultPollableMessageSource
implements PollableMessageSource,
Lifecycle,
RetryListener {
    protected static final ThreadLocal<AttributeAccessor> attributesHolder = new ThreadLocal();
    private static final DirectChannel dummyChannel = new DirectChannel();
    private final List<ChannelInterceptor> interceptors = new ArrayList<ChannelInterceptor>();
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private final SmartMessageConverter messageConverter;
    private MessageSource<?> source;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<Object> recoveryCallback;
    private MessageChannel errorChannel;
    private ErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
    private BiConsumer<AttributeAccessor, Message<?>> attributesProvider;
    private boolean running;

    public DefaultPollableMessageSource(@Nullable SmartMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setSource(MessageSource<?> source) {
        ProxyFactory pf = new ProxyFactory(source);
        class ReceiveAdvice
        implements MethodInterceptor {
            private final List<ChannelInterceptor> interceptors = new ArrayList<ChannelInterceptor>();

            ReceiveAdvice() {
            }

            public Object invoke(MethodInvocation invocation) throws Throwable {
                Object result = invocation.proceed();
                if (result instanceof Message) {
                    Message received = (Message)result;
                    for (ChannelInterceptor interceptor : this.interceptors) {
                        received = interceptor.preSend(received, (MessageChannel)dummyChannel);
                        if (received != null) continue;
                        return null;
                    }
                    return received;
                }
                return result;
            }
        }
        ReceiveAdvice advice = new ReceiveAdvice();
        advice.interceptors.addAll(this.interceptors);
        NameMatchMethodPointcutAdvisor sourceAdvisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
        sourceAdvisor.addMethodName("receive");
        pf.addAdvisor((Advisor)sourceAdvisor);
        this.source = (MessageSource)pf.getProxy();
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        retryTemplate.registerListener((RetryListener)this);
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<Object> recoveryCallback) {
        this.recoveryCallback = context -> {
            if (!this.shouldRequeue((Exception)((MessagingException)context.getLastThrowable()))) {
                return recoveryCallback.recover(context);
            }
            throw (MessagingException)context.getLastThrowable();
        };
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        Assert.notNull((Object)errorMessageStrategy, (String)"'errorMessageStrategy' cannot be null");
        this.errorMessageStrategy = errorMessageStrategy;
    }

    public void setAttributesProvider(BiConsumer<AttributeAccessor, Message<?>> attributesProvider) {
        this.attributesProvider = attributesProvider;
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        this.interceptors.add(index, interceptor);
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        if (!this.running && this.source instanceof Lifecycle) {
            ((Lifecycle)this.source).start();
        }
        this.running = true;
    }

    public synchronized void stop() {
        if (this.running && this.source instanceof Lifecycle) {
            ((Lifecycle)this.source).stop();
        }
        this.running = false;
    }

    @Override
    public boolean poll(MessageHandler handler) {
        return this.poll(handler, (ParameterizedTypeReference<?>)null);
    }

    @Override
    public boolean poll(MessageHandler handler, ParameterizedTypeReference<?> type) {
        Message<?> message = this.receive(type);
        if (message == null) {
            return false;
        }
        AcknowledgmentCallback ackCallback = StaticMessageHeaderAccessor.getAcknowledgmentCallback(message);
        try {
            if (this.retryTemplate == null) {
                this.handle(message, handler);
            } else {
                this.retryTemplate.execute(context -> {
                    this.handle(message, handler);
                    return null;
                }, this.recoveryCallback);
            }
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            if (this.retryTemplate == null && !this.shouldRequeue((Exception)((Object)e))) {
                try {
                    this.messagingTemplate.send((Object)this.errorChannel, (Message)this.errorMessageStrategy.buildErrorMessage((Throwable)e, attributesHolder.get()));
                }
                catch (MessagingException e1) {
                    this.requeueOrNack(message, ackCallback, e1);
                }
                boolean bl = true;
                return bl;
            }
            this.requeueOrNack(message, ackCallback, e);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            AckUtils.autoNack((AcknowledgmentCallback)ackCallback);
            if (e instanceof MessageHandlingException && ((MessageHandlingException)e).getFailedMessage().equals(message)) {
                throw (MessageHandlingException)e;
            }
            throw new MessageHandlingException(message, (Throwable)e);
        }
        finally {
            AckUtils.autoAck((AcknowledgmentCallback)ackCallback);
        }
    }

    private void requeueOrNack(Message<?> message, AcknowledgmentCallback ackCallback, MessagingException e) {
        if (ackCallback.isAcknowledged() || !this.shouldRequeue((Exception)((Object)e))) {
            AckUtils.autoNack((AcknowledgmentCallback)ackCallback);
            if (e.getFailedMessage().equals(message)) {
                throw e;
            }
            throw new MessageHandlingException(message, (Throwable)e);
        }
        AckUtils.requeue((AcknowledgmentCallback)ackCallback);
    }

    protected boolean shouldRequeue(Exception e) {
        boolean requeue = false;
        for (Throwable t = e.getCause(); t != null && !requeue; t = t.getCause()) {
            requeue = t instanceof RequeueCurrentMessageException;
        }
        return requeue;
    }

    public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
        if (this.recoveryCallback != null) {
            attributesHolder.set((AttributeAccessor)context);
        }
        return true;
    }

    public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        attributesHolder.remove();
    }

    public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
    }

    private Message<?> receive(ParameterizedTypeReference<?> type) {
        Message message = this.source.receive();
        if (message != null && type != null && this.messageConverter != null) {
            Class<Object> targetType = type == null ? Object.class : (type.getType() instanceof Class ? (Class<Object>)type.getType() : Object.class);
            Object payload = this.messageConverter.fromMessage(message, (Class)targetType, type);
            if (payload == null) {
                throw new MessageConversionException(message, "No converter could convert Message");
            }
            message = MessageBuilder.withPayload((Object)payload).copyHeaders((Map)message.getHeaders()).build();
        }
        return message;
    }

    private void doHandleMessage(MessageHandler handler, Message<?> message) {
        try {
            handler.handleMessage(message);
        }
        catch (Throwable t) {
            throw new MessageHandlingException(message, t);
        }
    }

    private void setAttributesIfNecessary(Message<?> message) {
        AttributeAccessor attributes;
        boolean needAttributes;
        boolean needHolder = this.errorChannel != null && this.retryTemplate == null;
        boolean bl = needAttributes = needHolder || this.retryTemplate != null;
        if (needHolder) {
            attributesHolder.set(ErrorMessageUtils.getAttributeAccessor(null, null));
        }
        if (needAttributes && (attributes = attributesHolder.get()) != null) {
            attributes.setAttribute("inputMessage", message);
            if (this.attributesProvider != null) {
                this.attributesProvider.accept(attributes, message);
            }
        }
    }

    private void handle(Message<?> message, MessageHandler handler) {
        this.setAttributesIfNecessary(message);
        this.doHandleMessage(handler, message);
    }

    static {
        dummyChannel.setBeanName("dummy.required.by.nonnull.api");
    }
}

