/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.stream.binder.test.AbstractDestination;
import org.springframework.messaging.Message;

public class OutputDestination
extends AbstractDestination {
    private final List<BlockingQueue<Message<?>>> messageQueues = new ArrayList();

    public Message<byte[]> receive(long timeout, int channelIndex) {
        try {
            return this.messageQueues.get(channelIndex).poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public Message<byte[]> receive() {
        return this.receive(0L, 0);
    }

    public Message<byte[]> receive(long timeout) {
        return this.receive(timeout, 0);
    }

    @Override
    void afterChannelIsSet(int channelIndex) {
        LinkedTransferQueue messageQueue = new LinkedTransferQueue();
        this.messageQueues.add(messageQueue);
        this.getChannel(channelIndex).subscribe(message -> this.messageQueues.get(channelIndex).offer(message));
    }
}

