/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;

@ConfigurationProperties(value="spring.cloud.stream.function")
public class StreamFunctionProperties {
    private String definition;
    private BindingServiceProperties bindingServiceProperties;
    private String inputDestinationName = "input";
    private String outputDestinationName = "output";
    private Map<String, List<String>> inputBindings = new HashMap<String, List<String>>();
    private Map<String, List<String>> outputBindings = new HashMap<String, List<String>>();
    private boolean batchMode;
    private boolean composeTo;
    private boolean composeFrom;

    public boolean isComposeTo() {
        return this.composeTo;
    }

    public boolean isComposeFrom() {
        return this.composeFrom;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.composeFrom = definition.startsWith("|");
        this.composeTo = definition.endsWith("|");
        this.definition = this.composeFrom ? definition.substring(1) : (this.composeTo ? definition.substring(0, definition.length() - 1) : definition);
    }

    BindingServiceProperties getBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    void setBindingServiceProperties(BindingServiceProperties bindingServiceProperties) {
        this.bindingServiceProperties = bindingServiceProperties;
    }

    String getInputDestinationName() {
        return this.inputDestinationName;
    }

    void setInputDestinationName(String inputDestinationName) {
        this.inputDestinationName = inputDestinationName;
    }

    String getOutputDestinationName() {
        return this.outputDestinationName;
    }

    void setOutputDestinationName(String outputDestinationName) {
        this.outputDestinationName = outputDestinationName;
    }

    public Map<String, List<String>> getInputBindings() {
        return this.inputBindings;
    }

    public Map<String, List<String>> getOutputBindings() {
        return this.outputBindings;
    }

    public void setOutputBindings(Map<String, List<String>> outputBindings) {
        this.outputBindings = outputBindings;
    }

    public void setInputBindings(Map<String, List<String>> inputBindings) {
        this.inputBindings = inputBindings;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }
}

