/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.stream.annotation.BindingProvider;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderTypeRegistry;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.binding.CompositeMessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.binding.MessageSourceBindingTargetFactory;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.ContentTypeConfiguration;
import org.springframework.cloud.stream.config.SmartMessageMethodArgumentResolver;
import org.springframework.cloud.stream.config.SmartPayloadArgumentResolver;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.integration.handler.support.MapArgumentResolver;
import org.springframework.integration.handler.support.PayloadExpressionArgumentResolver;
import org.springframework.integration.handler.support.PayloadsArgumentResolver;
import org.springframework.integration.support.NullAwarePayloadArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;

@Configuration
@Role(value=2)
@EnableConfigurationProperties(value={BindingServiceProperties.class})
@Import(value={ContentTypeConfiguration.class})
public class BinderFactoryAutoConfiguration {
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    private static final String SELF_CONTAINED_APP_PROPERTY_NAME = "spring.cloud.stream.internal.selfContained";
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Value(value="${spring.cloud.stream.internal.selfContained:}")
    private String selfContained;

    static Collection<BinderType> parseBinderConfigurations(ClassLoader classLoader, Resource resource) throws IOException, ClassNotFoundException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        ArrayList<BinderType> parsedBinderConfigurations = new ArrayList<BinderType>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String binderType = (String)entry.getKey();
            String[] binderConfigurationClassNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()));
            Class[] binderConfigurationClasses = new Class[binderConfigurationClassNames.length];
            int i = 0;
            for (String binderConfigurationClassName : binderConfigurationClassNames) {
                binderConfigurationClasses[i++] = ClassUtils.forName((String)binderConfigurationClassName, (ClassLoader)classLoader);
            }
            parsedBinderConfigurations.add(new BinderType(binderType, binderConfigurationClasses));
        }
        return parsedBinderConfigurations;
    }

    @Bean(value={"integrationMessageHandlerMethodFactory"})
    public static MessageHandlerMethodFactory messageHandlerMethodFactory(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, @Nullable Validator validator, ConfigurableListableBeanFactory clbf) {
        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        messageHandlerMethodFactory.setMessageConverter((MessageConverter)compositeMessageConverter);
        LinkedList<Object> resolvers = new LinkedList<Object>();
        resolvers.add((Object)new SmartPayloadArgumentResolver((MessageConverter)compositeMessageConverter, validator));
        resolvers.add((Object)new SmartMessageMethodArgumentResolver((MessageConverter)compositeMessageConverter));
        resolvers.add(new HeaderMethodArgumentResolver(clbf.getConversionService(), (ConfigurableBeanFactory)clbf));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new PayloadExpressionArgumentResolver());
        resolvers.add(new NullAwarePayloadArgumentResolver((MessageConverter)compositeMessageConverter));
        PayloadExpressionArgumentResolver payloadExpressionArgumentResolver = new PayloadExpressionArgumentResolver();
        payloadExpressionArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(payloadExpressionArgumentResolver);
        PayloadsArgumentResolver payloadsArgumentResolver = new PayloadsArgumentResolver();
        payloadsArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(payloadsArgumentResolver);
        MapArgumentResolver mapArgumentResolver = new MapArgumentResolver();
        mapArgumentResolver.setBeanFactory((BeanFactory)clbf);
        resolvers.add(mapArgumentResolver);
        messageHandlerMethodFactory.setArgumentResolvers(resolvers);
        messageHandlerMethodFactory.setValidator(validator);
        return messageHandlerMethodFactory;
    }

    @Bean
    public BinderTypeRegistry binderTypeRegistry(ConfigurableApplicationContext configurableApplicationContext) {
        HashMap<String, BinderType> binderTypes = new HashMap<String, BinderType>();
        ClassLoader classLoader = configurableApplicationContext.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/spring.binders");
            if (!(Boolean.valueOf(this.selfContained).booleanValue() || resources != null && resources.hasMoreElements())) {
                this.logger.debug((Object)"Failed to locate 'META-INF/spring.binders' resources on the classpath. Assuming standard boot 'META-INF/spring.factories' configuration is used");
            } else {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    UrlResource resource = new UrlResource(url);
                    for (BinderType binderType : BinderFactoryAutoConfiguration.parseBinderConfigurations(classLoader, (Resource)resource)) {
                        binderTypes.put(binderType.getDefaultName(), binderType);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BeanCreationException("Cannot create binder factory:", (Throwable)e);
        }
        return new DefaultBinderTypeRegistry(binderTypes);
    }

    @Bean
    public MessageConverterConfigurer messageConverterConfigurer(BindingServiceProperties bindingServiceProperties, @Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter) {
        return new MessageConverterConfigurer(bindingServiceProperties, compositeMessageConverter);
    }

    @Bean
    public SubscribableChannelBindingTargetFactory channelFactory(CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new SubscribableChannelBindingTargetFactory(compositeMessageChannelConfigurer);
    }

    @Bean
    public MessageSourceBindingTargetFactory messageSourceFactory(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, CompositeMessageChannelConfigurer compositeMessageChannelConfigurer) {
        return new MessageSourceBindingTargetFactory((SmartMessageConverter)compositeMessageConverter, compositeMessageChannelConfigurer);
    }

    @Bean
    public CompositeMessageChannelConfigurer compositeMessageChannelConfigurer(MessageConverterConfigurer messageConverterConfigurer) {
        ArrayList<MessageChannelConfigurer> configurerList = new ArrayList<MessageChannelConfigurer>();
        configurerList.add(messageConverterConfigurer);
        return new CompositeMessageChannelConfigurer(configurerList);
    }

    @Bean
    public InitializingBean functionToChannelBindingInitializer(@Nullable FunctionCatalog functionCatalog, @Nullable FunctionInspector functionInspector, BinderTypeRegistry bfac) {
        return new ImplicitFunctionToChannelBindingInitializer(functionCatalog, functionInspector, bfac);
    }

    private static class ImplicitFunctionToChannelBindingInitializer
    implements InitializingBean,
    BeanFactoryAware,
    EnvironmentAware {
        private ConfigurableListableBeanFactory beanFactory;
        private Environment environment;
        private final FunctionCatalog functionCatalog;
        private final FunctionInspector functionInspector;
        private final BinderTypeRegistry bfac;

        ImplicitFunctionToChannelBindingInitializer(FunctionCatalog functionCatalog, FunctionInspector functionInspector, BinderTypeRegistry bfac) {
            this.functionCatalog = functionCatalog;
            this.functionInspector = functionInspector;
            this.bfac = bfac;
        }

        public void afterPropertiesSet() {
            Class<?>[] configurationClasses = this.bfac.getAll().values().iterator().next().getConfigurationClasses();
            boolean bindingProvider = Stream.of(configurationClasses).filter(clazz -> AnnotationUtils.findAnnotation((Class)clazz, BindingProvider.class) != null).findFirst().isPresent();
            if (this.functionCatalog != null && ObjectUtils.isEmpty((Object[])this.beanFactory.getBeanNamesForAnnotation(EnableBinding.class))) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
                String name = this.determineFunctionName(this.functionCatalog, this.environment);
                if (StringUtils.hasText((String)name)) {
                    Object definedFunction = this.functionCatalog.lookup(name);
                    Class inputType = this.functionInspector.getInputType(definedFunction);
                    Class outputType = this.functionInspector.getOutputType(definedFunction);
                    if (!bindingProvider) {
                        if (Void.class.isAssignableFrom(outputType)) {
                            this.bind(Sink.class, registry);
                        } else if (Void.class.isAssignableFrom(inputType)) {
                            this.bind(Source.class, registry);
                        } else {
                            this.bind(Processor.class, registry);
                        }
                    }
                }
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        private String determineFunctionName(FunctionCatalog catalog, Environment environment) {
            String name = environment.getProperty("spring.cloud.stream.function.definition");
            if (!StringUtils.hasText((String)name)) {
                name = environment.getProperty("spring.cloud.function.definition");
            }
            if (!StringUtils.hasText((String)name) && Boolean.parseBoolean(environment.getProperty("spring.cloud.function.routing.enabled", "false"))) {
                name = "router";
            }
            if (!StringUtils.hasText((String)name) && catalog.size() >= 1 && catalog.size() <= 2) {
                name = ((FunctionInspector)catalog).getName(catalog.lookup(""));
            }
            if (StringUtils.hasText((String)name)) {
                ((StandardEnvironment)environment).getSystemProperties().putIfAbsent("spring.cloud.stream.function.definition", name);
            }
            return name;
        }

        private void bind(Class<?> type, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(type.getName())) {
                RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(BindableProxyFactory.class);
                rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(type);
                registry.registerBeanDefinition(type.getName(), (BeanDefinition)rootBeanDefinition);
            }
        }
    }
}

