/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MessageValues
implements Map<String, Object> {
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Object payload;

    public MessageValues(Message<?> message) {
        this.payload = message.getPayload();
        for (Map.Entry header : message.getHeaders().entrySet()) {
            this.headers.put((String)header.getKey(), header.getValue());
        }
    }

    public MessageValues(Object payload, Map<String, Object> headers) {
        this.payload = payload;
        this.headers.putAll(headers);
    }

    public Object getPayload() {
        return this.payload;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Message<?> toMessage(MessageBuilderFactory messageBuilderFactory) {
        return messageBuilderFactory.withPayload(this.payload).copyHeaders(this.headers).build();
    }

    public Message<?> toMessage() {
        return MessageBuilder.withPayload((Object)this.payload).copyHeaders(this.headers).build();
    }

    public void setPayload(Object payload) {
        Assert.notNull((Object)payload, (String)"'payload' cannot be null");
        this.payload = payload;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.headers.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.headers.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.headers.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.headers.putAll(m);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.headers.entrySet();
    }

    public void copyHeadersIfAbsent(Map<String, Object> headersToCopy) {
        for (Map.Entry<String, Object> headersToCopyEntry : headersToCopy.entrySet()) {
            if (this.containsKey(headersToCopyEntry.getKey())) continue;
            this.put(headersToCopyEntry.getKey(), headersToCopyEntry.getValue());
        }
    }
}

