/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class StringToByteArrayMessageConverter
extends AbstractFromMessageConverter {
    private static final List<MimeType> targetMimeTypes = new ArrayList<MimeType>();

    public StringToByteArrayMessageConverter() {
        super(targetMimeTypes);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{byte[].class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{String.class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        MimeType mimeType = this.getContentTypeResolver().resolve(message.getHeaders());
        byte[] converted = null;
        if (mimeType == null || mimeType.getParameter("Charset") == null) {
            converted = ((String)message.getPayload()).getBytes();
        } else {
            String encoding = mimeType.getParameter("Charset");
            if (encoding != null) {
                try {
                    converted = ((String)message.getPayload()).getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return converted;
    }

    static {
        targetMimeTypes.add(MimeTypeUtils.APPLICATION_OCTET_STREAM);
    }
}

