/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.aggregate.AggregateApplication;
import org.springframework.cloud.stream.aggregate.AggregatorParentConfiguration;
import org.springframework.cloud.stream.aggregate.SharedChannelRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AggregateApplicationBuilder {
    private SourceConfigurer sourceConfigurer;
    private SinkConfigurer sinkConfigurer;
    private List<ProcessorConfigurer> processorConfigurers = new ArrayList<ProcessorConfigurer>();
    private AggregateApplicationBuilder applicationBuilder = this;
    ConfigurableApplicationContext parentContext;

    public AggregateApplicationBuilder() {
        this(SpringApplication.run((Object[])AggregateApplicationBuilder.addAggregatorParentIfMissing(new Object[0]), (String[])new String[0]));
    }

    public AggregateApplicationBuilder(Object source, String ... args) {
        this(new Object[]{source}, args);
    }

    public AggregateApplicationBuilder(Object[] sources, String[] args) {
        this(SpringApplication.run((Object[])AggregateApplicationBuilder.addAggregatorParentIfMissing(sources), (String[])args));
    }

    public AggregateApplicationBuilder(ConfigurableApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    private static Object[] addAggregatorParentIfMissing(Object[] sources) {
        Object[] aggregateParentSources;
        if (!ObjectUtils.containsElement((Object[])sources, AggregatorParentConfiguration.class)) {
            ArrayList<Object> sourceList = new ArrayList<Object>(Arrays.asList(sources));
            sourceList.add(0, AggregatorParentConfiguration.class);
            aggregateParentSources = sourceList.toArray(new Object[sourceList.size()]);
        } else {
            aggregateParentSources = sources;
        }
        return aggregateParentSources;
    }

    public AggregateApplicationBuilder parent(Object source, String ... args) {
        return this.parent(new Object[]{source}, args);
    }

    public AggregateApplicationBuilder parent(Object[] sources, String[] args) {
        return this.parent(SpringApplication.run((Object[])AggregateApplicationBuilder.addAggregatorParentIfMissing(sources), (String[])args));
    }

    public AggregateApplicationBuilder parent(ConfigurableApplicationContext parentContext) {
        Assert.isNull((Object)this.parentContext, (String)"A parent context has already been set");
        this.parentContext = parentContext;
        return this;
    }

    public SourceConfigurer from(Class<?> app) {
        SourceConfigurer sourceConfigurer;
        this.sourceConfigurer = sourceConfigurer = new SourceConfigurer(app);
        return sourceConfigurer;
    }

    public ConfigurableApplicationContext run(String[] parentArgs) {
        AppConfigurer appConfigurer;
        int i;
        ConfigurableApplicationContext parentContext = this.parentContext != null ? this.parentContext : AggregateApplication.createParentContext(parentArgs);
        SharedChannelRegistry sharedChannelRegistry = (SharedChannelRegistry)parentContext.getBean(SharedChannelRegistry.class);
        ArrayList<AppConfigurer> apps = new ArrayList<AppConfigurer>();
        if (this.sourceConfigurer != null) {
            apps.add(this.sourceConfigurer);
        }
        if (!this.processorConfigurers.isEmpty()) {
            for (ProcessorConfigurer processorConfigurer : this.processorConfigurers) {
                apps.add(processorConfigurer);
            }
        }
        if (this.sinkConfigurer != null) {
            apps.add(this.sinkConfigurer);
        }
        LinkedHashMap appsToEmbed = new LinkedHashMap();
        for (i = 0; i < apps.size(); ++i) {
            appConfigurer = (AppConfigurer)apps.get(i);
            Class<?> appToEmbed = appConfigurer.getApp();
            if (appConfigurer.namespace == null) {
                appConfigurer.namespace = AggregateApplication.getNamespace(appConfigurer.getApp().getName(), i);
            }
            appsToEmbed.put(appToEmbed, appConfigurer.namespace);
        }
        AggregateApplication.prepareSharedChannelRegistry(sharedChannelRegistry, appsToEmbed);
        for (i = apps.size() - 1; i >= 0; --i) {
            appConfigurer = (AppConfigurer)apps.get(i);
            appConfigurer.embed();
        }
        return parentContext;
    }

    private ChildContextBuilder childContext(Class<?> app, ConfigurableApplicationContext parentContext, String namespace) {
        return new ChildContextBuilder(AggregateApplication.embedApp(parentContext, namespace, app));
    }

    private final class ChildContextBuilder {
        private SpringApplicationBuilder builder;
        private String configName;
        private String[] args;

        private ChildContextBuilder(SpringApplicationBuilder builder) {
            this.builder = builder;
        }

        public ChildContextBuilder profiles(String ... profiles) {
            if (profiles != null) {
                this.builder.profiles(profiles);
            }
            return this;
        }

        public ChildContextBuilder config(String ... configs) {
            if (configs != null) {
                this.configName = StringUtils.arrayToCommaDelimitedString((Object[])configs);
            }
            return this;
        }

        public ChildContextBuilder args(String ... args) {
            this.args = args;
            return this;
        }

        public void run() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.args != null) {
                args.addAll(Arrays.asList(this.args));
            }
            if (this.configName != null) {
                args.add("--spring.config.name=" + this.configName);
            }
            this.builder.run(args.toArray(new String[0]));
        }
    }

    public abstract class AppConfigurer<T extends AppConfigurer<T>> {
        Class<?> app;
        String[] args;
        String[] names;
        String[] profiles;
        String namespace;

        Class<?> getApp() {
            return this.app;
        }

        public T as(String ... names) {
            this.names = names;
            return this.getConfigurer();
        }

        public T args(String ... args) {
            this.args = args;
            return this.getConfigurer();
        }

        public T profiles(String ... profiles) {
            this.profiles = profiles;
            return this.getConfigurer();
        }

        private T getConfigurer() {
            return (T)this;
        }

        public T namespace(String namespace) {
            this.namespace = namespace;
            return this.getConfigurer();
        }

        public ConfigurableApplicationContext run(String ... args) {
            return AggregateApplicationBuilder.this.applicationBuilder.run(args);
        }

        void embed() {
            AggregateApplicationBuilder.this.childContext(this.app, AggregateApplicationBuilder.this.parentContext, this.namespace).args(this.args).config(this.names).profiles(this.profiles).run();
        }
    }

    public class ProcessorConfigurer
    extends AppConfigurer<ProcessorConfigurer> {
        public ProcessorConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.processorConfigurers.add(this);
        }

        public SinkConfigurer to(Class<?> sink) {
            return new SinkConfigurer(sink);
        }

        public ProcessorConfigurer via(Class<?> processor) {
            return new ProcessorConfigurer(processor);
        }
    }

    public class SinkConfigurer
    extends AppConfigurer<SinkConfigurer> {
        public SinkConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.sinkConfigurer = this;
        }
    }

    public class SourceConfigurer
    extends AppConfigurer<SourceConfigurer> {
        public SourceConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.sourceConfigurer = this;
        }

        public SinkConfigurer to(Class<?> sink) {
            return new SinkConfigurer(sink);
        }

        public ProcessorConfigurer via(Class<?> processor) {
            return new ProcessorConfigurer(processor);
        }
    }
}

