/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.test.binder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;

public class TestSupportBinder
implements Binder<MessageChannel, ConsumerProperties, ProducerProperties> {
    private final MessageCollectorImpl messageCollector = new MessageCollectorImpl();
    private final ConcurrentMap<String, MessageChannel> messageChannels = new ConcurrentHashMap<String, MessageChannel>();

    public Binding<MessageChannel> bindConsumer(String name, String group, MessageChannel inboundBindTarget, ConsumerProperties properties) {
        return new TestBinding(inboundBindTarget, null);
    }

    public Binding<MessageChannel> bindProducer(String name, MessageChannel outboundBindTarget, ProducerProperties properties) {
        final BlockingQueue queue = this.messageCollector.register(outboundBindTarget);
        ((SubscribableChannel)outboundBindTarget).subscribe(new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                queue.add(message);
            }
        });
        this.messageChannels.put(name, outboundBindTarget);
        return new TestBinding(outboundBindTarget, this.messageCollector);
    }

    public MessageCollector messageCollector() {
        return this.messageCollector;
    }

    public MessageChannel getChannelForName(String name) {
        return (MessageChannel)this.messageChannels.get(name);
    }

    private static final class TestBinding
    implements Binding<MessageChannel> {
        private final MessageChannel target;
        private final MessageCollectorImpl messageCollector;

        private TestBinding(MessageChannel target, MessageCollectorImpl messageCollector) {
            this.target = target;
            this.messageCollector = messageCollector;
        }

        public void unbind() {
            if (this.messageCollector != null) {
                this.messageCollector.unregister(this.target);
            }
        }
    }

    private static class MessageCollectorImpl
    implements MessageCollector {
        private final Map<MessageChannel, BlockingQueue<Message<?>>> results = new HashMap();

        private MessageCollectorImpl() {
        }

        private BlockingQueue<Message<?>> register(MessageChannel channel) {
            LinkedBlockingDeque result = new LinkedBlockingDeque();
            Assert.isTrue((!this.results.containsKey(channel) ? 1 : 0) != 0, (String)("Channel [" + channel + "] was already bound"));
            this.results.put(channel, result);
            return result;
        }

        private void unregister(MessageChannel channel) {
            Assert.notNull(this.results.remove(channel), (String)("Trying to unregister a mapping for an unknown channel [" + channel + "]"));
        }

        @Override
        public BlockingQueue<Message<?>> forChannel(MessageChannel channel) {
            BlockingQueue<Message<?>> queue = this.results.get(channel);
            Assert.notNull(queue, (String)("Channel [" + channel + "] was not bound by " + TestSupportBinder.class));
            return queue;
        }
    }
}

