/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.core.DeclarableCustomizer;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.thread.Threading;
import org.springframework.cloud.stream.binder.rabbit.RabbitMessageChannelBinder;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.MessageSourceCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.inbound.AmqpMessageSource;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={RabbitBinderConfigurationProperties.class, RabbitExtendedBindingProperties.class})
public class RabbitMessageChannelBinderConfiguration {
    @Autowired
    private ConnectionFactory rabbitConnectionFactory;
    @Autowired
    private RabbitProperties rabbitProperties;
    @Autowired
    private RabbitBinderConfigurationProperties rabbitBinderConfigurationProperties;
    @Autowired
    private RabbitExtendedBindingProperties rabbitExtendedBindingProperties;

    @Bean
    RabbitMessageChannelBinder rabbitMessageChannelBinder(final @Nullable List<ListenerContainerCustomizer<MessageListenerContainer>> listenerContainerCustomizers, @Nullable MessageSourceCustomizer<AmqpMessageSource> sourceCustomizer, final @Nullable List<ProducerMessageHandlerCustomizer<MessageHandler>> producerMessageHandlerCustomizers, @Nullable ConsumerEndpointCustomizer<AmqpInboundChannelAdapter> consumerCustomizer, List<DeclarableCustomizer> declarableCustomizers, @Nullable ConnectionNameStrategy connectionNameStrategy) {
        String connectionNamePrefix = this.rabbitBinderConfigurationProperties.getConnectionNamePrefix();
        ConnectionFactory connectionFactory = this.rabbitConnectionFactory;
        if (connectionFactory instanceof AbstractConnectionFactory) {
            AbstractConnectionFactory connectionFactory2 = (AbstractConnectionFactory)connectionFactory;
            if (connectionNamePrefix != null && connectionNameStrategy == null) {
                AtomicInteger nameIncrementer = new AtomicInteger();
                connectionFactory2.setConnectionNameStrategy(f -> connectionNamePrefix + "#" + nameIncrementer.getAndIncrement());
            }
        }
        ListenerContainerCustomizer<MessageListenerContainer> composedCistomizer = new ListenerContainerCustomizer<MessageListenerContainer>(this){
            final /* synthetic */ RabbitMessageChannelBinderConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            public void configure(MessageListenerContainer container, String destinationName, String group) {
                if (!CollectionUtils.isEmpty((Collection)listenerContainerCustomizers)) {
                    for (ListenerContainerCustomizer customizer : listenerContainerCustomizers) {
                        customizer.configure((Object)container, destinationName, group);
                    }
                }
            }
        };
        ProducerMessageHandlerCustomizer<MessageHandler> producerMessageHandlerCustomizer = new ProducerMessageHandlerCustomizer<MessageHandler>(this){
            final /* synthetic */ RabbitMessageChannelBinderConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            public void configure(MessageHandler handler, String destinationName) {
                if (!CollectionUtils.isEmpty((Collection)producerMessageHandlerCustomizers)) {
                    for (ProducerMessageHandlerCustomizer customizer : producerMessageHandlerCustomizers) {
                        customizer.configure(handler, destinationName);
                    }
                }
            }
        };
        RabbitMessageChannelBinder binder = new RabbitMessageChannelBinder(this.rabbitConnectionFactory, this.rabbitProperties, this.provisioningProvider(declarableCustomizers), composedCistomizer, sourceCustomizer);
        binder.setAdminAddresses(this.rabbitBinderConfigurationProperties.getAdminAddresses());
        binder.setCompressingPostProcessor(this.gZipPostProcessor());
        binder.setDecompressingPostProcessor(this.deCompressingPostProcessor());
        binder.setNodes(this.rabbitBinderConfigurationProperties.getNodes());
        binder.setExtendedBindingProperties(this.rabbitExtendedBindingProperties);
        binder.setProducerMessageHandlerCustomizer((ProducerMessageHandlerCustomizer)producerMessageHandlerCustomizer);
        binder.setConsumerEndpointCustomizer(consumerCustomizer);
        return binder;
    }

    @Bean
    MessagePostProcessor deCompressingPostProcessor() {
        return new DelegatingDecompressingPostProcessor();
    }

    @Bean
    MessagePostProcessor gZipPostProcessor() {
        GZipPostProcessor gZipPostProcessor = new GZipPostProcessor();
        if (this.rabbitBinderConfigurationProperties.getCompressionLevel() != null) {
            gZipPostProcessor.setLevel(this.rabbitBinderConfigurationProperties.getCompressionLevel().intValue());
        }
        return gZipPostProcessor;
    }

    @Bean
    RabbitExchangeQueueProvisioner provisioningProvider(List<DeclarableCustomizer> customizers) {
        return new RabbitExchangeQueueProvisioner(this.rabbitConnectionFactory, customizers);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    ListenerContainerCustomizer<MessageListenerContainer> listenerContainerVirtualThreadExecutorCustomizer() {
        return (container, destinationName, group) -> {
            if (container instanceof AbstractMessageListenerContainer) {
                AbstractMessageListenerContainer listenerContainer = (AbstractMessageListenerContainer)container;
                listenerContainer.setTaskExecutor((Executor)new VirtualThreadTaskExecutor(destinationName + "-"));
            }
        };
    }
}

