/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.LocalizedQueueConnectionFactory;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.core.support.BatchingStrategy;
import org.springframework.amqp.rabbit.core.support.SimpleBatchingStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.cloud.stream.binder.rabbit.RabbitExpressionEvaluatingInterceptor;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.inbound.AmqpMessageSource;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.AmqpMessageHeaderErrorMessageStrategy;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.AcknowledgmentCallback;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.StaticMessageHeaderAccessor;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<RabbitConsumerProperties>, ExtendedProducerProperties<RabbitProducerProperties>, RabbitExchangeQueueProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, RabbitConsumerProperties, RabbitProducerProperties>,
DisposableBean {
    private static final SimplePassthroughMessageConverter passThoughConverter = new SimplePassthroughMessageConverter();
    private static final AmqpMessageHeaderErrorMessageStrategy errorMessageStrategy = new AmqpMessageHeaderErrorMessageStrategy();
    private static final MessagePropertiesConverter inboundMessagePropertiesConverter = new DefaultMessagePropertiesConverter(){

        public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
            MessageProperties properties = super.toMessageProperties(source, envelope, charset);
            properties.setDeliveryMode(null);
            return properties;
        }
    };
    private final RabbitProperties rabbitProperties;
    private boolean destroyConnectionFactory;
    private ConnectionFactory connectionFactory;
    private MessagePostProcessor decompressingPostProcessor = new DelegatingDecompressingPostProcessor();
    private MessagePostProcessor compressingPostProcessor = new GZipPostProcessor();
    private volatile String[] adminAddresses;
    private volatile String[] nodes;
    private volatile boolean clustered;
    private RabbitExtendedBindingProperties extendedBindingProperties = new RabbitExtendedBindingProperties();

    public RabbitMessageChannelBinder(ConnectionFactory connectionFactory, RabbitProperties rabbitProperties, RabbitExchangeQueueProvisioner provisioningProvider) {
        super(new String[0], (ProvisioningProvider)provisioningProvider);
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        Assert.notNull((Object)rabbitProperties, (String)"rabbitProperties must not be null");
        this.connectionFactory = connectionFactory;
        this.rabbitProperties = rabbitProperties;
    }

    public void setDecompressingPostProcessor(MessagePostProcessor decompressingPostProcessor) {
        this.decompressingPostProcessor = decompressingPostProcessor;
    }

    public void setCompressingPostProcessor(MessagePostProcessor compressingPostProcessor) {
        this.compressingPostProcessor = compressingPostProcessor;
    }

    public void setAdminAddresses(String[] adminAddresses) {
        this.adminAddresses = Arrays.copyOf(adminAddresses, adminAddresses.length);
    }

    public void setNodes(String[] nodes) {
        this.nodes = Arrays.copyOf(nodes, nodes.length);
        this.clustered = nodes.length > 1;
    }

    public void setExtendedBindingProperties(RabbitExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void onInit() throws Exception {
        super.onInit();
        if (this.clustered) {
            String[] addresses = StringUtils.commaDelimitedListToStringArray((String)this.rabbitProperties.getAddresses());
            Assert.state((addresses.length == this.adminAddresses.length && addresses.length == this.nodes.length ? 1 : 0) != 0, (String)"'addresses', 'adminAddresses', and 'nodes' properties must have equal length");
            this.connectionFactory = new LocalizedQueueConnectionFactory(this.connectionFactory, addresses, this.adminAddresses, this.nodes, this.rabbitProperties.getVirtualHost(), this.rabbitProperties.getUsername(), this.rabbitProperties.getPassword(), this.rabbitProperties.getSsl().isEnabled(), this.rabbitProperties.getSsl().getKeyStore(), this.rabbitProperties.getSsl().getTrustStore(), this.rabbitProperties.getSsl().getKeyStorePassword(), this.rabbitProperties.getSsl().getTrustStorePassword());
            this.destroyConnectionFactory = true;
        }
    }

    public void destroy() throws Exception {
        if (this.connectionFactory instanceof DisposableBean && this.destroyConnectionFactory) {
            ((DisposableBean)this.connectionFactory).destroy();
        }
    }

    public RabbitConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RabbitProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination producerDestination, ExtendedProducerProperties<RabbitProducerProperties> producerProperties, MessageChannel errorChannel) {
        Assert.state((!HeaderMode.embeddedHeaders.equals((Object)producerProperties.getHeaderMode()) ? 1 : 0) != 0, (String)"the RabbitMQ binder does not support embedded headers since RabbitMQ supports headers natively");
        String prefix = ((RabbitProducerProperties)producerProperties.getExtension()).getPrefix();
        String exchangeName = producerDestination.getName();
        String destination = StringUtils.isEmpty((Object)prefix) ? exchangeName : exchangeName.substring(prefix.length());
        AmqpOutboundEndpoint endpoint = new AmqpOutboundEndpoint((AmqpTemplate)this.buildRabbitTemplate((RabbitProducerProperties)producerProperties.getExtension(), errorChannel != null));
        endpoint.setExchangeName(producerDestination.getName());
        RabbitProducerProperties extendedProperties = (RabbitProducerProperties)producerProperties.getExtension();
        boolean expressionInterceptorNeeded = this.expressionInterceptorNeeded(extendedProperties);
        String routingKeyExpression = extendedProperties.getRoutingKeyExpression();
        if (!producerProperties.isPartitioned()) {
            if (routingKeyExpression == null) {
                endpoint.setRoutingKey(destination);
            } else if (expressionInterceptorNeeded) {
                endpoint.setRoutingKeyExpressionString("headers['scst_routingKey']");
            } else {
                endpoint.setRoutingKeyExpressionString(routingKeyExpression);
            }
        } else if (routingKeyExpression == null) {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression(destination, false));
        } else if (expressionInterceptorNeeded) {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression("headers['scst_routingKey']", true));
        } else {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression(routingKeyExpression, true));
        }
        if (extendedProperties.getDelayExpression() != null) {
            if (expressionInterceptorNeeded) {
                endpoint.setDelayExpressionString("headers['scst_delay']");
            } else {
                endpoint.setDelayExpressionString(extendedProperties.getDelayExpression());
            }
        }
        DefaultAmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.outboundMapper();
        ArrayList<String> headerPatterns = new ArrayList<String>(extendedProperties.getHeaderPatterns().length + 1);
        headerPatterns.add("!scst_partition");
        headerPatterns.addAll(Arrays.asList(extendedProperties.getHeaderPatterns()));
        mapper.setRequestHeaderNames(headerPatterns.toArray(new String[headerPatterns.size()]));
        endpoint.setHeaderMapper((AmqpHeaderMapper)mapper);
        endpoint.setDefaultDeliveryMode(extendedProperties.getDeliveryMode());
        endpoint.setBeanFactory((BeanFactory)this.getBeanFactory());
        if (errorChannel != null) {
            this.checkConnectionFactoryIsErrorCapable();
            endpoint.setReturnChannel(errorChannel);
            endpoint.setConfirmNackChannel(errorChannel);
            endpoint.setConfirmAckChannel((MessageChannel)this.getApplicationContext().getBean("nullChannel", MessageChannel.class));
            endpoint.setConfirmCorrelationExpressionString("#root");
            endpoint.setErrorMessageStrategy((ErrorMessageStrategy)new DefaultErrorMessageStrategy());
        }
        endpoint.setHeadersMappedLast(true);
        return endpoint;
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) {
        RabbitProducerProperties extendedProperties = (RabbitProducerProperties)producerProperties.getExtension();
        if (this.expressionInterceptorNeeded(extendedProperties)) {
            ((AbstractMessageChannel)outputChannel).addInterceptor(0, (ChannelInterceptor)new RabbitExpressionEvaluatingInterceptor(extendedProperties.getRoutingKeyExpression(), extendedProperties.getDelayExpression(), this.getEvaluationContext()));
        }
    }

    private boolean expressionInterceptorNeeded(RabbitProducerProperties extendedProperties) {
        return extendedProperties.getRoutingKeyExpression() != null && extendedProperties.getRoutingKeyExpression().contains("payload") || extendedProperties.getDelayExpression() != null && extendedProperties.getDelayExpression().contains("payload");
    }

    private void checkConnectionFactoryIsErrorCapable() {
        if (!(this.connectionFactory instanceof CachingConnectionFactory)) {
            this.logger.warn((Object)("Unknown connection factory type, cannot determine error capabilities: " + this.connectionFactory.getClass()));
        } else {
            CachingConnectionFactory ccf = (CachingConnectionFactory)this.connectionFactory;
            if (!ccf.isPublisherConfirms() && !ccf.isPublisherReturns()) {
                this.logger.warn((Object)"Producer error channel is enabled, but the connection factory is not configured for returns or confirms; the error channel will receive no messages");
            } else if (!ccf.isPublisherConfirms()) {
                this.logger.info((Object)"Producer error channel is enabled, but the connection factory is only configured to handle returned messages; negative acks will not be reported");
            } else if (!ccf.isPublisherReturns()) {
                this.logger.info((Object)"Producer error channel is enabled, but the connection factory is only configured to handle negatively acked messages; returned messages will not be reported");
            }
        }
    }

    private String buildPartitionRoutingExpression(String expressionRoot, boolean rootIsExpression) {
        return rootIsExpression ? expressionRoot + " + '-' + headers['" + "scst_partition" + "']" : "'" + expressionRoot + "-' + headers['" + "scst_partition" + "']";
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination consumerDestination, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        Assert.state((!HeaderMode.embeddedHeaders.equals((Object)properties.getHeaderMode()) ? 1 : 0) != 0, (String)"the RabbitMQ binder does not support embedded headers since RabbitMQ supports headers natively");
        String destination = consumerDestination.getName();
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(this.connectionFactory);
        listenerContainer.setAcknowledgeMode(((RabbitConsumerProperties)properties.getExtension()).getAcknowledgeMode());
        listenerContainer.setChannelTransacted(((RabbitConsumerProperties)properties.getExtension()).isTransacted());
        listenerContainer.setDefaultRequeueRejected(((RabbitConsumerProperties)properties.getExtension()).isRequeueRejected());
        int concurrency = properties.getConcurrency();
        concurrency = concurrency > 0 ? concurrency : 1;
        listenerContainer.setConcurrentConsumers(concurrency);
        int maxConcurrency = ((RabbitConsumerProperties)properties.getExtension()).getMaxConcurrency();
        if (maxConcurrency > concurrency) {
            listenerContainer.setMaxConcurrentConsumers(maxConcurrency);
        }
        listenerContainer.setPrefetchCount(((RabbitConsumerProperties)properties.getExtension()).getPrefetch());
        listenerContainer.setRecoveryInterval(((RabbitConsumerProperties)properties.getExtension()).getRecoveryInterval());
        listenerContainer.setTxSize(((RabbitConsumerProperties)properties.getExtension()).getTxSize());
        listenerContainer.setTaskExecutor((Executor)new SimpleAsyncTaskExecutor(consumerDestination.getName() + "-"));
        listenerContainer.setQueueNames(new String[]{destination});
        listenerContainer.setAfterReceivePostProcessors(new MessagePostProcessor[]{this.decompressingPostProcessor});
        listenerContainer.setMessagePropertiesConverter(inboundMessagePropertiesConverter);
        listenerContainer.setExclusive(((RabbitConsumerProperties)properties.getExtension()).isExclusive());
        listenerContainer.setMissingQueuesFatal(((RabbitConsumerProperties)properties.getExtension()).getMissingQueuesFatal());
        if (((RabbitConsumerProperties)properties.getExtension()).getQueueDeclarationRetries() != null) {
            listenerContainer.setDeclarationRetries(((RabbitConsumerProperties)properties.getExtension()).getQueueDeclarationRetries().intValue());
        }
        if (((RabbitConsumerProperties)properties.getExtension()).getFailedDeclarationRetryInterval() != null) {
            listenerContainer.setFailedDeclarationRetryInterval(((RabbitConsumerProperties)properties.getExtension()).getFailedDeclarationRetryInterval().longValue());
        }
        if (this.getApplicationEventPublisher() != null) {
            listenerContainer.setApplicationEventPublisher(this.getApplicationEventPublisher());
        } else if (this.getApplicationContext() != null) {
            listenerContainer.setApplicationEventPublisher((ApplicationEventPublisher)this.getApplicationContext());
        }
        listenerContainer.afterPropertiesSet();
        AmqpInboundChannelAdapter adapter = new AmqpInboundChannelAdapter((AbstractMessageListenerContainer)listenerContainer);
        adapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        adapter.setBeanName("inbound." + destination);
        DefaultAmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.inboundMapper();
        mapper.setRequestHeaderNames(((RabbitConsumerProperties)properties.getExtension()).getHeaderPatterns());
        adapter.setHeaderMapper((AmqpHeaderMapper)mapper);
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(consumerDestination, group, (ConsumerProperties)properties);
        if (properties.getMaxAttempts() > 1) {
            adapter.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)properties));
            adapter.setRecoveryCallback((RecoveryCallback)errorInfrastructure.getRecoverer());
        } else {
            adapter.setErrorMessageStrategy((ErrorMessageStrategy)errorMessageStrategy);
            adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        }
        adapter.setMessageConverter((MessageConverter)passThoughConverter);
        return adapter;
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<RabbitConsumerProperties> consumerProperties) {
        AmqpMessageSource source = new AmqpMessageSource(this.connectionFactory, destination.getName());
        source.setRawMessageHeader(true);
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)source, this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true));
    }

    protected void postProcessPollableSource(DefaultPollableMessageSource bindingTarget) {
        bindingTarget.setAttributesProvider((accessor, message) -> {
            Object rawMessage = message.getHeaders().get((Object)"amqp_raw_message");
            if (rawMessage != null) {
                accessor.setAttribute("amqp_raw_message", rawMessage);
            }
        });
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return errorMessageStrategy;
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, final ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        if (((RabbitConsumerProperties)properties.getExtension()).isRepublishToDlq()) {
            return new MessageHandler(){
                private final RabbitTemplate template;
                private final String exchange;
                private final String routingKey;
                {
                    this.template = new RabbitTemplate(RabbitMessageChannelBinder.this.connectionFactory);
                    this.template.setUsePublisherConnection(true);
                    this.exchange = RabbitMessageChannelBinder.this.deadLetterExchangeName((RabbitCommonProperties)properties.getExtension());
                    this.routingKey = ((RabbitConsumerProperties)properties.getExtension()).getDeadLetterRoutingKey();
                }

                public void handleMessage(org.springframework.messaging.Message<?> message) throws MessagingException {
                    Message amqpMessage = (Message)message.getHeaders().get((Object)"amqp_raw_message");
                    if (!(message instanceof ErrorMessage)) {
                        RabbitMessageChannelBinder.this.logger.error((Object)("Expected an ErrorMessage, not a " + message.getClass().toString() + " for: " + message));
                    } else if (amqpMessage == null) {
                        RabbitMessageChannelBinder.this.logger.error((Object)("No raw message header in " + message));
                    } else {
                        Throwable cause = (Throwable)message.getPayload();
                        MessageProperties messageProperties = amqpMessage.getMessageProperties();
                        Map headers = messageProperties.getHeaders();
                        headers.put("x-exception-stacktrace", RabbitMessageChannelBinder.this.getStackTraceAsString(cause));
                        headers.put("x-exception-message", cause.getCause() != null ? cause.getCause().getMessage() : cause.getMessage());
                        headers.put("x-original-exchange", messageProperties.getReceivedExchange());
                        headers.put("x-original-routingKey", messageProperties.getReceivedRoutingKey());
                        if (((RabbitConsumerProperties)properties.getExtension()).getRepublishDeliveyMode() != null) {
                            messageProperties.setDeliveryMode(((RabbitConsumerProperties)properties.getExtension()).getRepublishDeliveyMode());
                        }
                        this.template.send(this.exchange, this.routingKey != null ? this.routingKey : messageProperties.getConsumerQueue(), amqpMessage);
                    }
                }
            };
        }
        if (properties.getMaxAttempts() > 1) {
            return new MessageHandler(){
                private final RejectAndDontRequeueRecoverer recoverer = new RejectAndDontRequeueRecoverer();

                public void handleMessage(org.springframework.messaging.Message<?> message) throws MessagingException {
                    Message amqpMessage = (Message)message.getHeaders().get((Object)"amqp_raw_message");
                    if (!(message instanceof ErrorMessage)) {
                        RabbitMessageChannelBinder.this.logger.error((Object)("Expected an ErrorMessage, not a " + message.getClass().toString() + " for: " + message));
                        throw new ListenerExecutionFailedException("Unexpected error message " + message, (Throwable)new AmqpRejectAndDontRequeueException(""), null);
                    }
                    if (amqpMessage == null) {
                        RabbitMessageChannelBinder.this.logger.error((Object)("No raw message header in " + message));
                        throw new ListenerExecutionFailedException("Unexpected error message " + message, (Throwable)new AmqpRejectAndDontRequeueException(""), amqpMessage);
                    }
                    this.recoverer.recover(amqpMessage, (Throwable)message.getPayload());
                }
            };
        }
        return super.getErrorMessageHandler(destination, group, properties);
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        MessageHandler handler = this.getErrorMessageHandler(destination, group, properties);
        if (handler != null) {
            return handler;
        }
        MessageHandler superHandler = super.getErrorMessageHandler(destination, group, properties);
        return message -> {
            AcknowledgmentCallback ack;
            Message amqpMessage = (Message)message.getHeaders().get((Object)"amqp_raw_message");
            if (!(message instanceof ErrorMessage)) {
                this.logger.error((Object)("Expected an ErrorMessage, not a " + message.getClass().toString() + " for: " + message));
            } else if (amqpMessage == null) {
                if (superHandler != null) {
                    superHandler.handleMessage(message);
                }
            } else if (message.getPayload() instanceof MessagingException && (ack = StaticMessageHeaderAccessor.getAcknowledgmentCallback((org.springframework.messaging.Message)((MessagingException)message.getPayload()).getFailedMessage())) != null) {
                if (((RabbitConsumerProperties)properties.getExtension()).isRequeueRejected()) {
                    ack.acknowledge(AcknowledgmentCallback.Status.REQUEUE);
                } else {
                    ack.acknowledge(AcknowledgmentCallback.Status.REJECT);
                }
            }
        };
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, ExtendedConsumerProperties<RabbitConsumerProperties> consumerProperties) {
        return destination.getName() + ".errors";
    }

    private String deadLetterExchangeName(RabbitCommonProperties properties) {
        if (properties.getDeadLetterExchange() == null) {
            return RabbitMessageChannelBinder.applyPrefix((String)properties.getPrefix(), (String)"DLX");
        }
        return properties.getDeadLetterExchange();
    }

    protected void afterUnbindConsumer(ConsumerDestination consumerDestination, String group, ExtendedConsumerProperties<RabbitConsumerProperties> consumerProperties) {
        ((RabbitExchangeQueueProvisioner)this.provisioningProvider).cleanAutoDeclareContext(consumerDestination.getName());
    }

    private RabbitTemplate buildRabbitTemplate(RabbitProducerProperties properties, boolean mandatory) {
        RabbitTemplate rabbitTemplate;
        if (properties.isBatchingEnabled()) {
            SimpleBatchingStrategy batchingStrategy = new SimpleBatchingStrategy(properties.getBatchSize(), properties.getBatchBufferLimit(), (long)properties.getBatchTimeout());
            rabbitTemplate = new BatchingRabbitTemplate((BatchingStrategy)batchingStrategy, (TaskScheduler)this.getApplicationContext().getBean("taskScheduler", TaskScheduler.class));
        } else {
            rabbitTemplate = new RabbitTemplate();
        }
        rabbitTemplate.setMessageConverter((MessageConverter)passThoughConverter);
        rabbitTemplate.setChannelTransacted(properties.isTransacted());
        rabbitTemplate.setConnectionFactory(this.connectionFactory);
        rabbitTemplate.setUsePublisherConnection(true);
        if (properties.isCompress()) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{this.compressingPostProcessor});
        }
        rabbitTemplate.setMandatory(mandatory);
        if (this.rabbitProperties != null && this.rabbitProperties.getTemplate().getRetry().isEnabled()) {
            RabbitProperties.Retry retry = this.rabbitProperties.getTemplate().getRetry();
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(retry.getMaxAttempts());
            ExponentialBackOffPolicy backOff = new ExponentialBackOffPolicy();
            backOff.setInitialInterval(retry.getInitialInterval().toMillis());
            backOff.setMultiplier(retry.getMultiplier());
            backOff.setMaxInterval(retry.getMaxInterval().toMillis());
            RetryTemplate retryTemplate = new RetryTemplate();
            retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
            retryTemplate.setBackOffPolicy((BackOffPolicy)backOff);
            rabbitTemplate.setRetryTemplate(retryTemplate);
        }
        rabbitTemplate.afterPropertiesSet();
        return rabbitTemplate;
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    private static final class SimplePassthroughMessageConverter
    extends AbstractMessageConverter {
        private static final SimpleMessageConverter converter = new SimpleMessageConverter();

        SimplePassthroughMessageConverter() {
        }

        protected Message createMessage(Object object, MessageProperties messageProperties) {
            if (object instanceof byte[]) {
                return new Message((byte[])object, messageProperties);
            }
            return converter.toMessage(object, messageProperties);
        }

        public Object fromMessage(Message message) throws MessageConversionException {
            return message.getBody();
        }
    }
}

