/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test.junit.rabbit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.util.Assert;

public abstract class AbstractExternalResourceTestSupport<R>
implements BeforeEachCallback {
    public static final String SCS_EXTERNAL_SERVERS_REQUIRED = "SCS_EXTERNAL_SERVERS_REQUIRED";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected R resource;
    private String resourceDescription;

    protected AbstractExternalResourceTestSupport(String resourceDescription) {
        Assert.hasText((String)resourceDescription, (String)"resourceDescription is required");
        this.resourceDescription = resourceDescription;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        try {
            this.obtainResource();
        }
        catch (Exception e) {
            this.maybeCleanup();
            Assertions.fail((String)"");
        }
    }

    private void maybeCleanup() {
        if (this.resource != null) {
            try {
                this.cleanupResource();
            }
            catch (Exception ignored) {
                this.logger.warn((Object)"Exception while trying to cleanup failed resource", (Throwable)ignored);
            }
        }
    }

    public R getResource() {
        return this.resource;
    }

    protected abstract void cleanupResource() throws Exception;

    protected abstract void obtainResource() throws Exception;
}

