/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test.junit.rabbit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.cloud.stream.test.junit.AbstractExternalResourceTestSupport;

public class RabbitTestSupport
extends AbstractExternalResourceTestSupport<CachingConnectionFactory> {
    private final boolean management;

    public RabbitTestSupport() {
        this(false);
    }

    public RabbitTestSupport(boolean management) {
        super("RABBIT");
        this.management = management;
    }

    protected void obtainResource() throws Exception {
        this.resource = new CachingConnectionFactory("localhost");
        ((CachingConnectionFactory)this.resource).createConnection().close();
        if (this.management) {
            Socket socket = SocketFactory.getDefault().createSocket("localhost", 15672);
            socket.close();
        }
    }

    protected void cleanupResource() throws Exception {
        ((CachingConnectionFactory)this.resource).destroy();
    }

    public static class RabbitProxy {
        private final int port;
        private final ExecutorService serverExec = Executors.newSingleThreadExecutor();
        private final ExecutorService socketExec = Executors.newCachedThreadPool();
        private volatile ServerSocket serverSocket;

        public RabbitProxy() throws IOException {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(0);
            this.port = serverSocket.getLocalPort();
            serverSocket.close();
        }

        public int getPort() {
            return this.port;
        }

        public void start() throws IOException {
            this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port);
            this.serverExec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            final Socket socket = RabbitProxy.this.serverSocket.accept();
                            RabbitProxy.this.socketExec.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        int c;
                                        final Socket rabbitSocket = SocketFactory.getDefault().createSocket("localhost", 5672);
                                        RabbitProxy.this.socketExec.execute(new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    int c;
                                                    InputStream is = rabbitSocket.getInputStream();
                                                    OutputStream os = socket.getOutputStream();
                                                    while ((c = is.read()) >= 0) {
                                                        os.write(c);
                                                    }
                                                }
                                                catch (IOException e) {
                                                    try {
                                                        socket.close();
                                                        rabbitSocket.close();
                                                    }
                                                    catch (IOException iOException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                        });
                                        InputStream is = socket.getInputStream();
                                        OutputStream os = rabbitSocket.getOutputStream();
                                        while ((c = is.read()) >= 0) {
                                            os.write(c);
                                        }
                                    }
                                    catch (IOException e) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        try {
                            RabbitProxy.this.serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            });
        }

        public void stop() throws IOException {
            this.serverSocket.close();
        }
    }
}

