/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.pulsar.provisioning;

import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.pulsar.properties.PulsarBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.pulsar.properties.PulsarConsumerProperties;
import org.springframework.cloud.stream.binder.pulsar.properties.PulsarProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarAdministration;
import org.springframework.pulsar.core.PulsarTopic;
import org.springframework.pulsar.core.PulsarTopicBuilder;

public class PulsarTopicProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<PulsarConsumerProperties>, ExtendedProducerProperties<PulsarProducerProperties>> {
    private final PulsarAdministration pulsarAdministration;
    private final PulsarBinderConfigurationProperties pulsarBinderConfigurationProperties;
    private final PulsarTopicBuilder topicBuilder;

    public PulsarTopicProvisioner(PulsarAdministration pulsarAdministration, PulsarBinderConfigurationProperties pulsarBinderConfigurationProperties) {
        this(pulsarAdministration, pulsarBinderConfigurationProperties, new PulsarTopicBuilder());
    }

    public PulsarTopicProvisioner(PulsarAdministration pulsarAdministration, PulsarBinderConfigurationProperties pulsarBinderConfigurationProperties, PulsarTopicBuilder topicBuilder) {
        this.pulsarAdministration = pulsarAdministration;
        this.pulsarBinderConfigurationProperties = pulsarBinderConfigurationProperties;
        this.topicBuilder = topicBuilder;
    }

    public ProducerDestination provisionProducerDestination(String name, ExtendedProducerProperties<PulsarProducerProperties> pulsarProducerProperties) throws ProvisioningException {
        Integer partitionCountFromBinding = ((PulsarProducerProperties)((Object)pulsarProducerProperties.getExtension())).getPartitionCount();
        int partitionCount = this.getPartitionCount(partitionCountFromBinding);
        PulsarTopic pulsarTopic = this.topicBuilder.name(name).numberOfPartitions(partitionCount).build();
        this.pulsarAdministration.createOrModifyTopics(new PulsarTopic[]{pulsarTopic});
        return new PulsarDestination(pulsarTopic.topicName(), pulsarTopic.numberOfPartitions());
    }

    private int getPartitionCount(@Nullable Integer partitionCountConfig) {
        Integer partitionCount = this.pulsarBinderConfigurationProperties.getPartitionCount();
        if (partitionCountConfig != null && partitionCountConfig > 0) {
            partitionCount = partitionCountConfig;
        }
        return partitionCount == null ? 0 : partitionCount;
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ExtendedConsumerProperties<PulsarConsumerProperties> pulsarConsumerProperties) throws ProvisioningException {
        Integer partitionCountFromBinding = ((PulsarConsumerProperties)((Object)pulsarConsumerProperties.getExtension())).getPartitionCount();
        int partitionCount = this.getPartitionCount(partitionCountFromBinding);
        PulsarTopic pulsarTopic = this.topicBuilder.name(name).numberOfPartitions(partitionCount).build();
        this.pulsarAdministration.createOrModifyTopics(new PulsarTopic[]{pulsarTopic});
        return new PulsarDestination(pulsarTopic.topicName(), pulsarTopic.numberOfPartitions());
    }

    private record PulsarDestination(String destinationName, Integer partitions) implements ProducerDestination,
    ConsumerDestination
    {
        public String getName() {
            return this.destinationName;
        }

        public String getNameForPartition(int partition) {
            return this.destinationName;
        }
    }
}

