/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.pulsar;

import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.pulsar.support.header.PulsarHeaderMapper;

class PulsarBinderHeaderMapper
implements PulsarHeaderMapper {
    private final PulsarHeaderMapper delegate;

    PulsarBinderHeaderMapper(PulsarHeaderMapper delegate) {
        this.delegate = delegate;
    }

    public Map<String, String> toPulsarHeaders(MessageHeaders springHeaders) {
        Map pulsarHeaders = this.delegate.toPulsarHeaders(springHeaders);
        pulsarHeaders.remove("id");
        pulsarHeaders.remove("timestamp");
        pulsarHeaders.remove("deliveryAttempt");
        pulsarHeaders.remove("scst_nativeHeadersPresent");
        return pulsarHeaders;
    }

    public MessageHeaders toSpringHeaders(Message<?> pulsarMessage) {
        MessageHeaders springHeaders = this.delegate.toSpringHeaders(pulsarMessage);
        if (!springHeaders.isEmpty()) {
            MessageHeaderAccessor mutableHeaders = new MessageHeaderAccessor();
            mutableHeaders.copyHeaders((Map)springHeaders);
            mutableHeaders.setHeader("scst_nativeHeadersPresent", (Object)Boolean.TRUE);
            springHeaders = mutableHeaders.getMessageHeaders();
        }
        return springHeaders;
    }
}

