/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis;

import java.util.ArrayList;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.cloud.stream.binder.kinesis.KinesisMessageChannelBinder;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;

public class KinesisBinderHealthIndicator
implements HealthIndicator {
    private final KinesisMessageChannelBinder kinesisMessageChannelBinder;

    public KinesisBinderHealthIndicator(KinesisMessageChannelBinder kinesisMessageChannelBinder) {
        this.kinesisMessageChannelBinder = kinesisMessageChannelBinder;
    }

    public Health health() {
        KinesisAsyncClient amazonKinesis = this.kinesisMessageChannelBinder.getAmazonKinesis();
        ArrayList<String> streamsInUse = new ArrayList<String>(this.kinesisMessageChannelBinder.getStreamsInUse());
        block4: for (String stream : streamsInUse) {
            while (true) {
                try {
                    amazonKinesis.listShards(request -> request.streamName(stream).maxResults(Integer.valueOf(1))).join();
                    continue block4;
                }
                catch (CompletionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof LimitExceededException) {
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return Health.down((Exception)ex).build();
                        }
                        continue;
                    }
                    return Health.down((Exception)ex).build();
                }
                break;
            }
        }
        return Health.up().build();
    }
}

