/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderHeaders;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisConsumerProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisProducerProperties;
import org.springframework.cloud.stream.binder.kinesis.provisioning.KinesisConsumerDestination;
import org.springframework.cloud.stream.binder.kinesis.provisioning.KinesisStreamProvisioner;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.aws.inbound.kinesis.KclMessageDrivenChannelAdapter;
import org.springframework.integration.aws.inbound.kinesis.KinesisMessageDrivenChannelAdapter;
import org.springframework.integration.aws.inbound.kinesis.KinesisMessageHeaderErrorMessageStrategy;
import org.springframework.integration.aws.inbound.kinesis.KinesisShardOffset;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.outbound.KinesisMessageHandler;
import org.springframework.integration.aws.outbound.KplMessageHandler;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.InterceptableChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class KinesisMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<KinesisConsumerProperties>, ExtendedProducerProperties<KinesisProducerProperties>, KinesisStreamProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, KinesisConsumerProperties, KinesisProducerProperties> {
    private static final ErrorMessageStrategy ERROR_MESSAGE_STRATEGY = new KinesisMessageHeaderErrorMessageStrategy();
    private final List<String> streamsInUse = new ArrayList<String>();
    private final KinesisBinderConfigurationProperties configurationProperties;
    private final AmazonDynamoDBStreamsAdapterClient dynamoDBStreamsAdapter;
    private final AmazonKinesisAsync amazonKinesis;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final AmazonCloudWatch cloudWatchClient;
    private final AmazonDynamoDB dynamoDBClient;
    private KinesisExtendedBindingProperties extendedBindingProperties = new KinesisExtendedBindingProperties();
    @Nullable
    private ConcurrentMetadataStore checkpointStore;
    @Nullable
    private LockRegistry lockRegistry;
    @Nullable
    private KinesisProducerConfiguration kinesisProducerConfiguration;
    private EvaluationContext evaluationContext;
    private List<KinesisClientLibConfiguration> kinesisClientLibConfigurations;

    public KinesisMessageChannelBinder(KinesisBinderConfigurationProperties configurationProperties, KinesisStreamProvisioner provisioningProvider, AmazonKinesisAsync amazonKinesis, AWSCredentialsProvider awsCredentialsProvider, @Nullable AmazonDynamoDB dynamoDBClient, @Nullable AmazonDynamoDBStreams dynamoDBStreams, @Nullable AmazonCloudWatch cloudWatchClient) {
        super(KinesisMessageChannelBinder.headersToMap(configurationProperties), (ProvisioningProvider)provisioningProvider);
        Assert.notNull((Object)amazonKinesis, (String)"'amazonKinesis' must not be null");
        Assert.notNull((Object)awsCredentialsProvider, (String)"'awsCredentialsProvider' must not be null");
        this.configurationProperties = configurationProperties;
        this.amazonKinesis = amazonKinesis;
        this.cloudWatchClient = cloudWatchClient;
        this.dynamoDBClient = dynamoDBClient;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.dynamoDBStreamsAdapter = dynamoDBStreams != null ? new AmazonDynamoDBStreamsAdapterClient(dynamoDBStreams) : null;
    }

    public void setExtendedBindingProperties(KinesisExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void setCheckpointStore(ConcurrentMetadataStore checkpointStore) {
        this.checkpointStore = checkpointStore;
    }

    public void setLockRegistry(LockRegistry lockRegistry) {
        this.lockRegistry = lockRegistry;
    }

    public void setKinesisProducerConfiguration(KinesisProducerConfiguration kinesisProducerConfiguration) {
        this.kinesisProducerConfiguration = kinesisProducerConfiguration;
    }

    public void setKinesisClientLibConfigurations(List<KinesisClientLibConfiguration> kinesisClientLibConfigurations) {
        this.kinesisClientLibConfigurations = kinesisClientLibConfigurations;
    }

    public KinesisConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public KinesisProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    public AmazonKinesisAsync getAmazonKinesis() {
        return this.amazonKinesis;
    }

    public List<String> getStreamsInUse() {
        return this.streamsInUse;
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<KinesisProducerProperties> producerProperties, MessageChannel errorChannel) {
        FunctionExpression partitionKeyExpression = new FunctionExpression(m -> m.getHeaders().containsKey((Object)"scst_partition") ? m.getHeaders().get((Object)"scst_partition") : Integer.valueOf(m.getPayload().hashCode()));
        AbstractAwsMessageHandler<?> messageHandler = this.configurationProperties.isKplKclEnabled() ? this.createKplMessageHandler(destination, partitionKeyExpression) : this.createKinesisMessageHandler(destination, partitionKeyExpression);
        messageHandler.setSync(((KinesisProducerProperties)producerProperties.getExtension()).isSync());
        messageHandler.setSendTimeout(((KinesisProducerProperties)producerProperties.getExtension()).getSendTimeout());
        messageHandler.setFailureChannel(errorChannel);
        messageHandler.setBeanFactory((BeanFactory)this.getBeanFactory());
        this.streamsInUse.add(destination.getName());
        return messageHandler;
    }

    private AbstractAwsMessageHandler<?> createKinesisMessageHandler(ProducerDestination destination, FunctionExpression<Message<?>> partitionKeyExpression) {
        KinesisMessageHandler messageHandler = new KinesisMessageHandler(this.amazonKinesis);
        messageHandler.setStream(destination.getName());
        messageHandler.setPartitionKeyExpression(partitionKeyExpression);
        return messageHandler;
    }

    private AbstractAwsMessageHandler<?> createKplMessageHandler(ProducerDestination destination, FunctionExpression<Message<?>> partitionKeyExpression) {
        KplMessageHandler messageHandler = new KplMessageHandler(new KinesisProducer(this.kinesisProducerConfiguration));
        messageHandler.setStream(destination.getName());
        messageHandler.setPartitionKeyExpression(partitionKeyExpression);
        return messageHandler;
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, final ExtendedProducerProperties<KinesisProducerProperties> producerProperties) {
        if (outputChannel instanceof InterceptableChannel && producerProperties.isPartitioned()) {
            ((InterceptableChannel)outputChannel).addInterceptor(0, new ChannelInterceptor(){
                private final PartitionKeyExtractorStrategy partitionKeyExtractorStrategy;
                {
                    this.partitionKeyExtractorStrategy = StringUtils.hasText((String)producerProperties.getPartitionKeyExtractorName()) ? (PartitionKeyExtractorStrategy)KinesisMessageChannelBinder.this.getBeanFactory().getBean(producerProperties.getPartitionKeyExtractorName(), PartitionKeyExtractorStrategy.class) : message -> producerProperties.getPartitionKeyExpression().getValue(KinesisMessageChannelBinder.this.evaluationContext, (Object)message);
                }

                public Message<?> preSend(Message<?> message, MessageChannel channel) {
                    Object partitionKey = this.partitionKeyExtractorStrategy.extractKey(message);
                    return MessageBuilder.fromMessage(message).setHeader("scst_partitionOverride", partitionKey).build();
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<KinesisConsumerProperties> properties) {
        ConsumerDestination destinationToUse = destination;
        if (((KinesisConsumerProperties)properties.getExtension()).isDynamoDbStreams()) {
            DescribeTableResult describeTableResult = this.dynamoDBClient.describeTable(destinationToUse.getName());
            String latestStreamArn = describeTableResult.getTable().getLatestStreamArn();
            if (!StringUtils.hasText((String)latestStreamArn)) throw new ProvisioningException("The DynamoDB table [" + destinationToUse.getName() + "] doesn't have Streams enabled.");
            destinationToUse = new KinesisConsumerDestination(latestStreamArn, Collections.emptyList());
        } else {
            this.streamsInUse.add(destinationToUse.getName());
        }
        if (!this.configurationProperties.isKplKclEnabled()) return this.createKinesisConsumerEndpoint(destinationToUse, group, properties);
        return this.createKclConsumerEndpoint(destinationToUse, group, properties);
    }

    private MessageProducer createKclConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<KinesisConsumerProperties> properties) {
        String consumerGroup;
        KclMessageDrivenChannelAdapter adapter;
        KinesisConsumerProperties kinesisConsumerProperties = (KinesisConsumerProperties)properties.getExtension();
        String shardIteratorType = kinesisConsumerProperties.getShardIteratorType();
        AmazonDynamoDBStreamsAdapterClient amazonKinesisClient = kinesisConsumerProperties.isDynamoDbStreams() ? this.dynamoDBStreamsAdapter : this.amazonKinesis;
        String stream = destination.getName();
        KinesisClientLibConfiguration kinesisClientLibConfiguration = this.obtainKinesisClientLibConfiguration(stream, group);
        if (kinesisClientLibConfiguration == null) {
            adapter = new KclMessageDrivenChannelAdapter(stream, (AmazonKinesis)amazonKinesisClient, this.cloudWatchClient, this.dynamoDBClient, this.awsCredentialsProvider);
            boolean anonymous = !StringUtils.hasText((String)group);
            consumerGroup = anonymous ? "anonymous." + UUID.randomUUID().toString() : group;
            adapter.setConsumerGroup(consumerGroup);
            if (StringUtils.hasText((String)shardIteratorType)) {
                adapter.setStreamInitialSequence(InitialPositionInStream.valueOf((String)shardIteratorType));
            }
            adapter.setIdleBetweenPolls(kinesisConsumerProperties.getIdleBetweenPolls());
            adapter.setConsumerBackoff(kinesisConsumerProperties.getConsumerBackoff());
            if (kinesisConsumerProperties.getWorkerId() != null) {
                adapter.setWorkerId(kinesisConsumerProperties.getWorkerId());
            }
        } else {
            adapter = new KclMessageDrivenChannelAdapter(kinesisClientLibConfiguration, (AmazonKinesis)amazonKinesisClient, this.cloudWatchClient, this.dynamoDBClient);
            consumerGroup = kinesisClientLibConfiguration.getApplicationName();
        }
        adapter.setCheckpointMode(kinesisConsumerProperties.getCheckpointMode());
        adapter.setCheckpointsInterval(kinesisConsumerProperties.getCheckpointInterval().longValue());
        adapter.setListenerMode(kinesisConsumerProperties.getListenerMode());
        if (properties.isUseNativeDecoding()) {
            adapter.setConverter(null);
        } else {
            adapter.setConverter(bytes -> bytes);
        }
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, consumerGroup, (ConsumerProperties)properties);
        adapter.setErrorMessageStrategy(ERROR_MESSAGE_STRATEGY);
        adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        adapter.setBindSourceRecord(true);
        return adapter;
    }

    private KinesisClientLibConfiguration obtainKinesisClientLibConfiguration(String stream, String group) {
        KinesisClientLibConfiguration candidate = null;
        for (KinesisClientLibConfiguration conf : this.kinesisClientLibConfigurations) {
            if (!stream.equals(conf.getStreamName())) continue;
            candidate = conf;
            if (!Objects.equals(group, conf.getApplicationName())) continue;
            break;
        }
        return candidate;
    }

    private MessageProducer createKinesisConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<KinesisConsumerProperties> properties) {
        KinesisConsumerProperties kinesisConsumerProperties = (KinesisConsumerProperties)properties.getExtension();
        HashSet<KinesisShardOffset> shardOffsets = null;
        String shardIteratorType = kinesisConsumerProperties.getShardIteratorType();
        KinesisShardOffset kinesisShardOffset = KinesisShardOffset.latest();
        if (StringUtils.hasText((String)shardIteratorType)) {
            String[] typeValue = shardIteratorType.split(":", 2);
            ShardIteratorType iteratorType = ShardIteratorType.valueOf((String)typeValue[0]);
            kinesisShardOffset = new KinesisShardOffset(iteratorType);
            if (typeValue.length > 1) {
                if (ShardIteratorType.AT_TIMESTAMP.equals((Object)iteratorType)) {
                    kinesisShardOffset.setTimestamp(new Date(Long.parseLong(typeValue[1])));
                } else {
                    kinesisShardOffset.setSequenceNumber(typeValue[1]);
                }
            }
        }
        if (properties.getInstanceCount() > 1) {
            shardOffsets = new HashSet<KinesisShardOffset>();
            KinesisConsumerDestination kinesisConsumerDestination = (KinesisConsumerDestination)destination;
            List<Shard> shards = kinesisConsumerDestination.getShards();
            for (int i = 0; i < shards.size(); ++i) {
                if (i % properties.getInstanceCount() != properties.getInstanceIndex()) continue;
                KinesisShardOffset shardOffset = new KinesisShardOffset(kinesisShardOffset);
                shardOffset.setStream(destination.getName());
                shardOffset.setShard(shards.get(i).getShardId());
                shardOffsets.add(shardOffset);
            }
        }
        AmazonDynamoDBStreamsAdapterClient amazonKinesisClient = kinesisConsumerProperties.isDynamoDbStreams() ? this.dynamoDBStreamsAdapter : this.amazonKinesis;
        KinesisMessageDrivenChannelAdapter adapter = CollectionUtils.isEmpty(shardOffsets) ? new KinesisMessageDrivenChannelAdapter((AmazonKinesis)amazonKinesisClient, new String[]{destination.getName()}) : new KinesisMessageDrivenChannelAdapter((AmazonKinesis)amazonKinesisClient, shardOffsets.toArray(new KinesisShardOffset[0]));
        boolean anonymous = !StringUtils.hasText((String)group);
        String consumerGroup = anonymous ? "anonymous." + UUID.randomUUID().toString() : group;
        adapter.setConsumerGroup(consumerGroup);
        adapter.setStreamInitialSequence(anonymous || StringUtils.hasText((String)shardIteratorType) ? kinesisShardOffset : KinesisShardOffset.trimHorizon());
        adapter.setListenerMode(kinesisConsumerProperties.getListenerMode());
        if (properties.isUseNativeDecoding()) {
            adapter.setConverter(null);
        } else {
            adapter.setConverter(bytes -> bytes);
        }
        adapter.setCheckpointMode(kinesisConsumerProperties.getCheckpointMode());
        adapter.setRecordsLimit(kinesisConsumerProperties.getRecordsLimit());
        adapter.setIdleBetweenPolls(kinesisConsumerProperties.getIdleBetweenPolls());
        adapter.setConsumerBackoff(kinesisConsumerProperties.getConsumerBackoff());
        adapter.setCheckpointsInterval(kinesisConsumerProperties.getCheckpointInterval().longValue());
        if (this.checkpointStore != null) {
            adapter.setCheckpointStore(this.checkpointStore);
        }
        adapter.setLockRegistry(this.lockRegistry);
        adapter.setConcurrency(properties.getConcurrency());
        adapter.setStartTimeout(kinesisConsumerProperties.getStartTimeout());
        adapter.setDescribeStreamBackoff(this.configurationProperties.getDescribeStreamBackoff());
        adapter.setDescribeStreamRetries(this.configurationProperties.getDescribeStreamRetries());
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, consumerGroup, (ConsumerProperties)properties);
        adapter.setErrorMessageStrategy(ERROR_MESSAGE_STRATEGY);
        adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        adapter.setBindSourceRecord(true);
        return adapter;
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return ERROR_MESSAGE_STRATEGY;
    }

    private static String[] headersToMap(KinesisBinderConfigurationProperties configurationProperties) {
        Assert.notNull((Object)configurationProperties, (String)"'configurationProperties' must not be null");
        if (ObjectUtils.isEmpty((Object[])configurationProperties.getHeaders())) {
            return BinderHeaders.STANDARD_HEADERS;
        }
        String[] combinedHeadersToMap = Arrays.copyOfRange(BinderHeaders.STANDARD_HEADERS, 0, BinderHeaders.STANDARD_HEADERS.length + configurationProperties.getHeaders().length);
        System.arraycopy(configurationProperties.getHeaders(), 0, combinedHeadersToMap, BinderHeaders.STANDARD_HEADERS.length, configurationProperties.getHeaders().length);
        return combinedHeadersToMap;
    }
}

