/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.AbstractKafkaHeaderMapper;
import org.springframework.kafka.support.MimeTypeJsonDeserializer;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;

@Deprecated
public class BinderHeaderMapper
extends AbstractKafkaHeaderMapper {
    private static final List<String> DEFAULT_TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    private static final List<String> DEFAULT_TO_STRING_CLASSES = Arrays.asList("org.springframework.util.MimeType", "org.springframework.http.MediaType");
    public static final String JSON_TYPES = "spring_json_header_types";
    private final ObjectMapper objectMapper;
    private final Set<String> trustedPackages = new LinkedHashSet<String>(DEFAULT_TRUSTED_PACKAGES);
    private final Set<String> toStringClasses = new LinkedHashSet<String>(DEFAULT_TO_STRING_CLASSES);

    public BinderHeaderMapper() {
        this(new ObjectMapper());
    }

    public BinderHeaderMapper(ObjectMapper objectMapper) {
        this(objectMapper, "!id", "!timestamp", "*");
    }

    public BinderHeaderMapper(String ... patterns) {
        this(new ObjectMapper(), patterns);
    }

    public BinderHeaderMapper(ObjectMapper objectMapper, String ... patterns) {
        super(patterns);
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.noNullElements((Object[])patterns, (String)"'patterns' must not have null elements");
        this.objectMapper = objectMapper;
        SimpleModule module = new SimpleModule().addDeserializer(MimeType.class, (JsonDeserializer)new MimeTypeJsonDeserializer(objectMapper));
        this.objectMapper.registerModule((Module)module);
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected Set<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    protected Set<String> getToStringClasses() {
        return this.toStringClasses;
    }

    public void addTrustedPackages(String ... trustedPackages) {
        if (trustedPackages != null) {
            for (String whiteList : trustedPackages) {
                if ("*".equals(whiteList)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(whiteList);
            }
        }
    }

    public void addToStringClasses(String ... classNames) {
        this.toStringClasses.addAll(Arrays.asList(classNames));
    }

    public void fromHeaders(MessageHeaders headers, Headers target) {
        HashMap jsonHeaders = new HashMap();
        headers.forEach((k, v) -> {
            block6: {
                if (this.matches((String)k, v)) {
                    if (v instanceof byte[]) {
                        target.add((Header)new RecordHeader(k, (byte[])v));
                    } else {
                        try {
                            Object value = v;
                            String className = v.getClass().getName();
                            if (this.toStringClasses.contains(className)) {
                                value = v.toString();
                                className = "java.lang.String";
                            }
                            target.add((Header)new RecordHeader(k, this.getObjectMapper().writeValueAsBytes(value)));
                            jsonHeaders.put(k, className);
                        }
                        catch (Exception e) {
                            if (!this.logger.isDebugEnabled()) break block6;
                            this.logger.debug((Object)("Could not map " + k + " with type " + v.getClass().getName()));
                        }
                    }
                }
            }
        });
        if (jsonHeaders.size() > 0) {
            try {
                target.add((Header)new RecordHeader(JSON_TYPES, this.getObjectMapper().writeValueAsBytes(jsonHeaders)));
            }
            catch (JsonProcessingException | IllegalStateException e) {
                this.logger.error((Object)"Could not add json types header", e);
            }
        }
    }

    public void toHeaders(Headers source, Map<String, Object> headers) {
        Map types = null;
        for (Header next : source) {
            if (!next.key().equals(JSON_TYPES)) continue;
            try {
                types = (Map)this.getObjectMapper().readValue(next.value(), HashMap.class);
            }
            catch (IOException e) {
                this.logger.error((Object)("Could not decode json types: " + new String(next.value())), (Throwable)e);
            }
            break;
        }
        Map jsonTypes = types;
        source.forEach(h -> {
            if (!h.key().equals(JSON_TYPES)) {
                if (jsonTypes != null && jsonTypes.containsKey(h.key())) {
                    Class type = Object.class;
                    String requestedType = (String)jsonTypes.get(h.key());
                    boolean trusted = false;
                    try {
                        trusted = this.trusted(requestedType);
                        if (trusted) {
                            type = ClassUtils.forName((String)requestedType, null);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Could not load class for header: " + h.key()), (Throwable)e);
                    }
                    if (trusted) {
                        try {
                            headers.put(h.key(), this.getObjectMapper().readValue(h.value(), type));
                        }
                        catch (IOException e) {
                            this.logger.error((Object)("Could not decode json type: " + new String(h.value()) + " for key: " + h.key()), (Throwable)e);
                            headers.put(h.key(), h.value());
                        }
                    } else {
                        headers.put(h.key(), new NonTrustedHeaderType(h.value(), requestedType));
                    }
                } else {
                    headers.put(h.key(), h.value());
                }
            }
        });
    }

    protected boolean trusted(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            int lastDot = requestedType.lastIndexOf(".");
            if (lastDot < 0) {
                return false;
            }
            String packageName = requestedType.substring(0, lastDot);
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage) && !packageName.startsWith(trustedPackage + ".")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class NonTrustedHeaderType {
        private final byte[] headerValue;
        private final String untrustedType;

        NonTrustedHeaderType(byte[] headerValue, String untrustedType) {
            this.headerValue = headerValue;
            this.untrustedType = untrustedType;
        }

        public byte[] getHeaderValue() {
            return this.headerValue;
        }

        public String getUntrustedType() {
            return this.untrustedType;
        }

        public String toString() {
            try {
                return "NonTrustedHeaderType [headerValue=" + new String(this.headerValue, StandardCharsets.UTF_8) + ", untrustedType=" + this.untrustedType + "]";
            }
            catch (Exception e) {
                return "NonTrustedHeaderType [headerValue=" + Arrays.toString(this.headerValue) + ", untrustedType=" + this.untrustedType + "]";
            }
        }
    }
}

