/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.AppInfoParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderHealthIndicator;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderJaasInitializerListener;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.admin.AdminUtilsOperation;
import org.springframework.cloud.stream.binder.kafka.admin.Kafka09AdminUtilsOperation;
import org.springframework.cloud.stream.binder.kafka.admin.Kafka10AdminUtilsOperation;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.config.codec.kryo.KryoCodecAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.integration.codec.Codec;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={KryoCodecAutoConfiguration.class, PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={KafkaBinderConfigurationProperties.class, KafkaExtendedBindingProperties.class})
public class KafkaBinderConfiguration {
    protected static final Log logger = LogFactory.getLog(KafkaBinderConfiguration.class);
    @Autowired
    private Codec codec;
    @Autowired
    private KafkaBinderConfigurationProperties configurationProperties;
    @Autowired
    private KafkaExtendedBindingProperties kafkaExtendedBindingProperties;
    @Autowired
    private ProducerListener producerListener;
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private AdminUtilsOperation adminUtilsOperation;

    @Bean
    KafkaTopicProvisioner provisioningProvider() {
        return new KafkaTopicProvisioner(this.configurationProperties, this.adminUtilsOperation);
    }

    @Bean
    KafkaMessageChannelBinder kafkaMessageChannelBinder() {
        KafkaMessageChannelBinder kafkaMessageChannelBinder = new KafkaMessageChannelBinder(this.configurationProperties, this.provisioningProvider());
        kafkaMessageChannelBinder.setCodec(this.codec);
        kafkaMessageChannelBinder.setProducerListener((ProducerListener<byte[], byte[]>)this.producerListener);
        kafkaMessageChannelBinder.setExtendedBindingProperties(this.kafkaExtendedBindingProperties);
        return kafkaMessageChannelBinder;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    ProducerListener producerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    KafkaBinderHealthIndicator healthIndicator(KafkaMessageChannelBinder kafkaMessageChannelBinder) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key.deserializer", ByteArrayDeserializer.class);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        if (!ObjectUtils.isEmpty((Object)this.configurationProperties.getConsumerConfiguration())) {
            props.putAll(this.configurationProperties.getConsumerConfiguration());
        }
        if (!props.containsKey("bootstrap.servers")) {
            props.put("bootstrap.servers", this.configurationProperties.getKafkaConnectionString());
        }
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(props);
        KafkaBinderHealthIndicator indicator = new KafkaBinderHealthIndicator(kafkaMessageChannelBinder, (ConsumerFactory<?, ?>)consumerFactory);
        indicator.setTimeout(this.configurationProperties.getHealthTimeout());
        return indicator;
    }

    @Bean
    public PublicMetrics kafkaBinderMetrics(KafkaMessageChannelBinder kafkaMessageChannelBinder) {
        return new KafkaBinderMetrics(kafkaMessageChannelBinder, this.configurationProperties);
    }

    @Bean(name={"adminUtilsOperation"})
    @Conditional(value={Kafka09Present.class})
    @ConditionalOnClass(name={"kafka.admin.AdminUtils"})
    public AdminUtilsOperation kafka09AdminUtilsOperation() {
        logger.info((Object)"AdminUtils selected: Kafka 0.9 AdminUtils");
        return new Kafka09AdminUtilsOperation();
    }

    @Bean(name={"adminUtilsOperation"})
    @Conditional(value={Kafka10Present.class})
    @ConditionalOnClass(name={"kafka.admin.AdminUtils"})
    public AdminUtilsOperation kafka10AdminUtilsOperation() {
        logger.info((Object)"AdminUtils selected: Kafka 0.10 AdminUtils");
        return new Kafka10AdminUtilsOperation();
    }

    @Bean
    public ApplicationListener<?> jaasInitializer() throws IOException {
        return new KafkaBinderJaasInitializerListener();
    }

    public static class JaasConfigurationProperties {
        private JaasLoginModuleConfiguration kafka;
        private JaasLoginModuleConfiguration zookeeper;
    }

    static class Kafka09Present
    implements Condition {
        Kafka09Present() {
        }

        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            return AppInfoParser.getVersion().startsWith("0.9");
        }
    }

    static class Kafka10Present
    implements Condition {
        Kafka10Present() {
        }

        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            return AppInfoParser.getVersion().startsWith("0.10");
        }
    }
}

