/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.admin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import kafka.utils.ZkUtils;
import org.springframework.cloud.stream.binder.kafka.admin.AdminUtilsOperation;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class Kafka10AdminUtilsOperation
implements AdminUtilsOperation {
    private static Class<?> ADMIN_UTIL_CLASS;

    @Override
    public void invokeAddPartitions(ZkUtils zkUtils, String topic, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable) {
        try {
            Method[] declaredMethods = ADMIN_UTIL_CLASS.getDeclaredMethods();
            Method addPartitions = null;
            for (Method m : declaredMethods) {
                if (!m.getName().equals("addPartitions")) continue;
                addPartitions = m;
            }
            if (addPartitions == null) {
                throw new InvocationTargetException(new RuntimeException("method not found"));
            }
            addPartitions.invoke(null, zkUtils, topic, numPartitions, replicaAssignmentStr, checkBrokerAvailable, null);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
    }

    @Override
    public short errorCodeFromTopicMetadata(String topic, ZkUtils zkUtils) {
        try {
            Method fetchTopicMetadataFromZk = ReflectionUtils.findMethod(ADMIN_UTIL_CLASS, (String)"fetchTopicMetadataFromZk", (Class[])new Class[]{String.class, ZkUtils.class});
            Object result = fetchTopicMetadataFromZk.invoke(null, topic, zkUtils);
            Class topicMetadataClass = ClassUtils.forName((String)"org.apache.kafka.common.requests.MetadataResponse$TopicMetadata", null);
            Method errorCodeMethod = ReflectionUtils.findMethod((Class)topicMetadataClass, (String)"error");
            Object obj = errorCodeMethod.invoke(result, new Object[0]);
            Method code = ReflectionUtils.findMethod(obj.getClass(), (String)"code");
            return (Short)code.invoke(obj, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AdminUtils class not found", e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return 0;
    }

    @Override
    public int partitionSize(String topic, ZkUtils zkUtils) {
        try {
            Method fetchTopicMetadataFromZk = ReflectionUtils.findMethod(ADMIN_UTIL_CLASS, (String)"fetchTopicMetadataFromZk", (Class[])new Class[]{String.class, ZkUtils.class});
            Object result = fetchTopicMetadataFromZk.invoke(null, topic, zkUtils);
            Class topicMetadataClass = ClassUtils.forName((String)"org.apache.kafka.common.requests.MetadataResponse$TopicMetadata", null);
            Method partitionsMetadata = ReflectionUtils.findMethod((Class)topicMetadataClass, (String)"partitionMetadata");
            List foo = (List)partitionsMetadata.invoke(result, new Object[0]);
            return foo.size();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AdminUtils class not found", e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return 0;
    }

    @Override
    public void invokeCreateTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig) {
        try {
            Method[] declaredMethods = ADMIN_UTIL_CLASS.getDeclaredMethods();
            Method createTopic = null;
            for (Method m : declaredMethods) {
                if (!m.getName().equals("createTopic") || !m.getParameterTypes()[m.getParameterTypes().length - 1].getName().endsWith("RackAwareMode")) continue;
                createTopic = m;
                break;
            }
            if (createTopic == null) {
                throw new InvocationTargetException(new RuntimeException("method not found"));
            }
            createTopic.invoke(null, zkUtils, topic, partitions, replicationFactor, topicConfig, null);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
    }

    static {
        try {
            ADMIN_UTIL_CLASS = ClassUtils.forName((String)"kafka.admin.AdminUtils", null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AdminUtils class not found", e);
        }
    }
}

