/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;

public class SendToDlqAndContinue
implements ConsumerRecordRecoverer {
    private final Map<String, DeadLetterPublishingRecoverer> dlqDispatchers = new HashMap<String, DeadLetterPublishingRecoverer>();

    public void sendToDlq(ConsumerRecord<?, ?> consumerRecord, Exception exception) {
        DeadLetterPublishingRecoverer kafkaStreamsDlqDispatch = this.dlqDispatchers.get(consumerRecord.topic());
        kafkaStreamsDlqDispatch.accept(consumerRecord, exception);
    }

    void addKStreamDlqDispatch(String topic, DeadLetterPublishingRecoverer kafkaStreamsDlqDispatch) {
        this.dlqDispatchers.put(topic, kafkaStreamsDlqDispatch);
    }

    public void accept(ConsumerRecord<?, ?> consumerRecord, Exception e) {
        this.dlqDispatchers.get(consumerRecord.topic()).accept(consumerRecord, e);
    }
}

