/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.aot;

import java.util.stream.Stream;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.cloud.stream.binder.kafka.streams.GlobalKTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KTableBoundElementFactory;
import org.springframework.lang.Nullable;

public class KafkaStreamsBinderRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        KafkaStreamsBinderRuntimeHints.registerKafkaStreamsReflectionHints(hints);
        KafkaStreamsBinderRuntimeHints.registerKafkaStreamsJniHints(hints);
        hints.resources().registerPattern("*/kafka-streams-version.properties");
        ProxyHints proxyHints = hints.proxies();
        KafkaStreamsBinderRuntimeHints.registerSpringJdkProxy(proxyHints, KStreamBoundElementFactory.KStreamWrapper.class, KStream.class);
        KafkaStreamsBinderRuntimeHints.registerSpringJdkProxy(proxyHints, KTableBoundElementFactory.KTableWrapper.class, KTable.class);
        KafkaStreamsBinderRuntimeHints.registerSpringJdkProxy(proxyHints, GlobalKTableBoundElementFactory.GlobalKTableWrapper.class, GlobalKTable.class);
    }

    private static void registerKafkaStreamsJniHints(RuntimeHints hints) {
        hints.jni().registerType(RocksDBException.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        hints.jni().registerType(Status.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        hints.resources().registerPattern("librocksdbjni-*");
    }

    private static void registerKafkaStreamsReflectionHints(RuntimeHints hints) {
        ReflectionHints reflectionHints = hints.reflection();
        Stream.of(DefaultProductionExceptionHandler.class, LogAndFailExceptionHandler.class, FailOnInvalidTimestamp.class, DefaultKafkaClientSupplier.class, StreamsPartitionAssignor.class).forEach(type -> reflectionHints.registerType(type, builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS})));
        reflectionHints.registerType(TypeReference.of((String)"org.apache.kafka.streams.processor.internals.StateDirectory$StateDirectoryProcessFile"), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
    }

    private static void registerSpringJdkProxy(ProxyHints proxyHints, Class<?> ... proxiedInterfaces) {
        proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces((Class[])proxiedInterfaces));
    }
}

