/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Collections;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class KafkaStreamsBinderEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String SEND_TO_DLQ_AND_CONTINUE_BEAN_NAME = "sendToDlqAndContinue";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String ineligibleDefinitionsPropertyKey = "spring.cloud.function.ineligible-definitions";
        Object ineligibleDefinitions = SEND_TO_DLQ_AND_CONTINUE_BEAN_NAME;
        if (environment.getProperty(ineligibleDefinitionsPropertyKey) != null) {
            ineligibleDefinitions = (String)ineligibleDefinitions + "," + environment.getProperty(ineligibleDefinitionsPropertyKey);
        }
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("kafkaStreamsBinderIneligibleDefinitions", Collections.singletonMap(ineligibleDefinitionsPropertyKey, ineligibleDefinitions)));
    }
}

