/*
 * Copyright 2018-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashMap;
import java.util.Map;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.stream.config.BindingHandlerAdvise.MappingsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

/**
 * {@link EnableAutoConfiguration Auto-configuration} for extended binding metadata for Kafka Streams.
 *
 * @author Chris Bono
 * @since 3.2
 */
@Configuration(proxyBeanMethods = false)
@Lazy(false)
public class ExtendedBindingHandlerMappingsProviderAutoConfiguration {

	@Bean
	public MappingsProvider kafkaStreamsExtendedPropertiesDefaultMappingsProvider() {
		return () -> {
			Map<ConfigurationPropertyName, ConfigurationPropertyName> mappings = new HashMap<>();
			mappings.put(
					ConfigurationPropertyName.of("spring.cloud.stream.kafka.streams"),
					ConfigurationPropertyName.of("spring.cloud.stream.kafka.streams.default"));
			mappings.put(
					ConfigurationPropertyName.of("spring.cloud.stream.kafka.streams.bindings"),
					ConfigurationPropertyName.of("spring.cloud.stream.kafka.streams.default"));
			return mappings;
		};
	}

}
