/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.processor.TaskMetadata;
import org.apache.kafka.streams.processor.ThreadMetadata;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;

class KafkaStreamsBinderHealthIndicator
extends AbstractHealthIndicator {
    private final KafkaStreamsRegistry kafkaStreamsRegistry;

    KafkaStreamsBinderHealthIndicator(KafkaStreamsRegistry kafkaStreamsRegistry) {
        super("Kafka-streams health check failed");
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        boolean up = true;
        for (KafkaStreams kStream : this.kafkaStreamsRegistry.getKafkaStreams()) {
            up &= kStream.state().isRunning();
            builder.withDetails(KafkaStreamsBinderHealthIndicator.buildDetails(kStream));
        }
        builder.status(up ? Status.UP : Status.DOWN);
    }

    private static Map<String, Object> buildDetails(KafkaStreams kStreams) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        if (kStreams.state().isRunning()) {
            for (ThreadMetadata metadata : kStreams.localThreadsMetadata()) {
                details.put("threadName", metadata.threadName());
                details.put("threadState", metadata.threadState());
                details.put("activeTasks", KafkaStreamsBinderHealthIndicator.taskDetails(metadata.activeTasks()));
                details.put("standbyTasks", KafkaStreamsBinderHealthIndicator.taskDetails(metadata.standbyTasks()));
            }
        }
        return details;
    }

    private static Map<String, Object> taskDetails(Set<TaskMetadata> taskMetadata) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        for (TaskMetadata metadata : taskMetadata) {
            details.put("taskId", metadata.taskId());
            details.put("partitions", metadata.topicPartitions().stream().map(p -> "partition=" + p.partition() + ", topic=" + p.topic()).collect(Collectors.toList()));
        }
        return details;
    }
}

