/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Produced;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderUtils;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

class KStreamBinder
extends AbstractBinder<KStream<Object, Object>, ExtendedConsumerProperties<KafkaStreamsConsumerProperties>, ExtendedProducerProperties<KafkaStreamsProducerProperties>>
implements ExtendedPropertiesBinder<KStream<Object, Object>, KafkaStreamsConsumerProperties, KafkaStreamsProducerProperties> {
    private static final Log LOG = LogFactory.getLog(KStreamBinder.class);
    private final KafkaTopicProvisioner kafkaTopicProvisioner;
    private KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties = new KafkaStreamsExtendedBindingProperties();
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;
    private final KafkaStreamsMessageConversionDelegate kafkaStreamsMessageConversionDelegate;
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;
    private final KeyValueSerdeResolver keyValueSerdeResolver;
    private final Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers;

    KStreamBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate kafkaStreamsMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KeyValueSerdeResolver keyValueSerdeResolver, Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers) {
        this.binderConfigurationProperties = binderConfigurationProperties;
        this.kafkaTopicProvisioner = kafkaTopicProvisioner;
        this.kafkaStreamsMessageConversionDelegate = kafkaStreamsMessageConversionDelegate;
        this.kafkaStreamsBindingInformationCatalogue = KafkaStreamsBindingInformationCatalogue2;
        this.keyValueSerdeResolver = keyValueSerdeResolver;
        this.kafkaStreamsDlqDispatchers = kafkaStreamsDlqDispatchers;
    }

    protected Binding<KStream<Object, Object>> doBindConsumer(String name, String group, KStream<Object, Object> inputTarget, ExtendedConsumerProperties<KafkaStreamsConsumerProperties> properties) {
        this.kafkaStreamsBindingInformationCatalogue.registerConsumerProperties(inputTarget, (KafkaStreamsConsumerProperties)((Object)properties.getExtension()));
        if (!StringUtils.hasText((String)group)) {
            group = this.binderConfigurationProperties.getApplicationId();
        }
        KafkaStreamsBinderUtils.prepareConsumerBinding(name, group, (ApplicationContext)this.getApplicationContext(), this.kafkaTopicProvisioner, this.binderConfigurationProperties, properties, this.kafkaStreamsDlqDispatchers);
        return new DefaultBinding(name, group, inputTarget, null);
    }

    protected Binding<KStream<Object, Object>> doBindProducer(String name, KStream<Object, Object> outboundBindTarget, ExtendedProducerProperties<KafkaStreamsProducerProperties> properties) {
        ExtendedProducerProperties extendedProducerProperties = new ExtendedProducerProperties((Object)new KafkaProducerProperties());
        this.kafkaTopicProvisioner.provisionProducerDestination(name, extendedProducerProperties);
        Serde<?> keySerde = this.keyValueSerdeResolver.getOuboundKeySerde((KafkaStreamsProducerProperties)((Object)properties.getExtension()));
        Serde<?> valueSerde = this.keyValueSerdeResolver.getOutboundValueSerde((ProducerProperties)properties, (KafkaStreamsProducerProperties)((Object)properties.getExtension()));
        this.to(properties.isUseNativeEncoding(), name, outboundBindTarget, keySerde, valueSerde);
        return new DefaultBinding(name, null, outboundBindTarget, null);
    }

    private void to(boolean isNativeEncoding, String name, KStream<Object, Object> outboundBindTarget, Serde<Object> keySerde, Serde<Object> valueSerde) {
        if (!isNativeEncoding) {
            LOG.info((Object)("Native encoding is disabled for " + name + ". Outbound message conversion done by Spring Cloud Stream."));
            this.kafkaStreamsMessageConversionDelegate.serializeOnOutbound(outboundBindTarget).to(name, Produced.with(keySerde, valueSerde));
        } else {
            LOG.info((Object)("Native encoding is enabled for " + name + ". Outbound serialization done at the broker."));
            outboundBindTarget.to(name, Produced.with(keySerde, valueSerde));
        }
    }

    public KafkaStreamsConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (KafkaStreamsConsumerProperties)((Object)this.kafkaStreamsExtendedBindingProperties.getExtendedConsumerProperties(channelName));
    }

    public KafkaStreamsProducerProperties getExtendedProducerProperties(String channelName) {
        return (KafkaStreamsProducerProperties)((Object)this.kafkaStreamsExtendedBindingProperties.getExtendedProducerProperties(channelName));
    }

    public void setKafkaStreamsExtendedBindingProperties(KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties) {
        this.kafkaStreamsExtendedBindingProperties = kafkaStreamsExtendedBindingProperties;
    }

    public String getDefaultsPrefix() {
        return this.kafkaStreamsExtendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.kafkaStreamsExtendedBindingProperties.getExtendedPropertiesEntryClass();
    }
}

