/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;

public class QueryableStoreRegistry {
    private final Set<KafkaStreams> kafkaStreams = new HashSet<KafkaStreams>();

    public <T> T getQueryableStoreType(String storeName, QueryableStoreType<T> storeType) {
        for (KafkaStreams kafkaStream : this.kafkaStreams) {
            try {
                Object store = kafkaStream.store(storeName, storeType);
                if (store == null) continue;
                return (T)store;
            }
            catch (InvalidStateStoreException invalidStateStoreException) {
            }
        }
        return null;
    }

    void registerKafkaStreams(KafkaStreams kafkaStreams) {
        this.kafkaStreams.add(kafkaStreams);
    }
}

