/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.kafka.streams")
public class KafkaStreamsExtendedBindingProperties
implements ExtendedBindingProperties<KafkaStreamsConsumerProperties, KafkaStreamsProducerProperties> {
    private Map<String, KafkaStreamsBindingProperties> bindings = new HashMap<String, KafkaStreamsBindingProperties>();

    public Map<String, KafkaStreamsBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, KafkaStreamsBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public KafkaStreamsConsumerProperties getExtendedConsumerProperties(String binding) {
        if (this.bindings.containsKey(binding) && this.bindings.get(binding).getConsumer() != null) {
            return this.bindings.get(binding).getConsumer();
        }
        return new KafkaStreamsConsumerProperties();
    }

    public KafkaStreamsProducerProperties getExtendedProducerProperties(String binding) {
        if (this.bindings.containsKey(binding) && this.bindings.get(binding).getProducer() != null) {
            return this.bindings.get(binding).getProducer();
        }
        return new KafkaStreamsProducerProperties();
    }
}

