/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamStreamListenerParameterAdapter;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamStreamListenerResultAdapter;
import org.springframework.cloud.stream.binder.kafka.streams.KTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsStreamListenerSetupMethodOrchestrator;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.QueryableStoreRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.SendToDlqAndContinue;
import org.springframework.cloud.stream.binder.kafka.streams.StreamsBuilderFactoryManager;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

@EnableConfigurationProperties(value={KafkaStreamsExtendedBindingProperties.class})
@ConditionalOnBean(value={BindingService.class})
public class KafkaStreamsBinderSupportAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kafka.streams.binder")
    public KafkaStreamsBinderConfigurationProperties binderConfigurationProperties() {
        return new KafkaStreamsBinderConfigurationProperties();
    }

    @Bean(value={"streamConfigGlobalProperties"})
    public Map<String, Object> streamConfigGlobalProperties(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", binderConfigurationProperties.getKafkaConnectionString());
        props.put("default.key.serde", Serdes.ByteArraySerde.class.getName());
        props.put("default.value.serde", Serdes.ByteArraySerde.class.getName());
        props.put("application.id", binderConfigurationProperties.getApplicationId());
        if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.logAndContinue) {
            props.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        } else if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.logAndFail) {
            props.put("default.deserialization.exception.handler", LogAndFailExceptionHandler.class);
        } else if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.sendToDlq) {
            props.put("default.deserialization.exception.handler", SendToDlqAndContinue.class);
        }
        if (!ObjectUtils.isEmpty((Object)binderConfigurationProperties.getConfiguration())) {
            props.putAll(binderConfigurationProperties.getConfiguration());
        }
        return props;
    }

    @Bean
    public KStreamStreamListenerResultAdapter kstreamStreamListenerResultAdapter() {
        return new KStreamStreamListenerResultAdapter();
    }

    @Bean
    public KStreamStreamListenerParameterAdapter kstreamStreamListenerParameterAdapter(KafkaStreamsMessageConversionDelegate kstreamBoundMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new KStreamStreamListenerParameterAdapter(kstreamBoundMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public KafkaStreamsStreamListenerSetupMethodOrchestrator kafkaStreamsStreamListenerSetupMethodOrchestrator(BindingServiceProperties bindingServiceProperties, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KStreamStreamListenerParameterAdapter kafkaStreamListenerParameterAdapter, Collection<StreamListenerResultAdapter> streamListenerResultAdapters, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        return new KafkaStreamsStreamListenerSetupMethodOrchestrator(bindingServiceProperties, kafkaStreamsExtendedBindingProperties, keyValueSerdeResolver, kafkaStreamsBindingInformationCatalogue, kafkaStreamListenerParameterAdapter, streamListenerResultAdapters, binderConfigurationProperties);
    }

    @Bean
    public KafkaStreamsMessageConversionDelegate messageConversionDelegate(CompositeMessageConverterFactory compositeMessageConverterFactory, SendToDlqAndContinue sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        return new KafkaStreamsMessageConversionDelegate(compositeMessageConverterFactory, sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue2, binderConfigurationProperties);
    }

    @Bean
    public KStreamBoundElementFactory kStreamBoundElementFactory(BindingServiceProperties bindingServiceProperties, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new KStreamBoundElementFactory(bindingServiceProperties, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public KTableBoundElementFactory kTableBoundElementFactory() {
        return new KTableBoundElementFactory();
    }

    @Bean
    public SendToDlqAndContinue sendToDlqAndContinue() {
        return new SendToDlqAndContinue();
    }

    @Bean
    public KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue() {
        return new KafkaStreamsBindingInformationCatalogue();
    }

    @Bean
    public KeyValueSerdeResolver keyValueSerdeResolver(@Qualifier(value="streamConfigGlobalProperties") Object streamConfigGlobalProperties, KafkaStreamsBinderConfigurationProperties kafkaStreamsBinderConfigurationProperties) {
        return new KeyValueSerdeResolver((Map)streamConfigGlobalProperties, kafkaStreamsBinderConfigurationProperties);
    }

    @Bean
    public QueryableStoreRegistry queryableStoreTypeRegistry() {
        return new QueryableStoreRegistry();
    }

    @Bean
    public StreamsBuilderFactoryManager streamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, QueryableStoreRegistry queryableStoreRegistry) {
        return new StreamsBuilderFactoryManager(kafkaStreamsBindingInformationCatalogue, queryableStoreRegistry);
    }
}

