/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure;

import org.springframework.batch.item.file.transform.Range;
import org.springframework.core.convert.converter.Converter;

public class RangeConverter
implements Converter<String, Range> {
    public Range convert(String source) {
        if (source == null) {
            return null;
        }
        String[] columns = source.split("-");
        if (columns.length == 1) {
            int start = Integer.parseInt(columns[0]);
            return new Range(start);
        }
        if (columns.length == 2) {
            int start = Integer.parseInt(columns[0]);
            int end = Integer.parseInt(columns[1]);
            return new Range(start, end);
        }
        throw new IllegalArgumentException(String.format("%s is in an illegal format.  Ranges must be specified as startIndex-endIndex", source));
    }
}

