/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.batch.item.kafka.KafkaItemWriter;
import org.springframework.batch.item.kafka.builder.KafkaItemWriterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.kafka.autoconfigure.KafkaProperties;
import org.springframework.cloud.task.batch.autoconfigure.kafka.KafkaItemWriterProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.util.Assert;

@AutoConfiguration
@EnableConfigurationProperties(value={KafkaProperties.class, KafkaItemWriterProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
public class KafkaItemWriterAutoConfiguration {
    @Autowired
    private KafkaProperties kafkaProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.kafkaitemwriter", name={"topic"})
    public KafkaItemWriter<Object, Map<String, Object>> kafkaItemWriter(KafkaItemWriterProperties kafkaItemWriterProperties, ProducerFactory<Object, Map<String, Object>> producerFactory, @Qualifier(value="batchItemKeyMapper") Converter<Map<String, Object>, Object> itemKeyMapper) {
        this.validateProperties(kafkaItemWriterProperties);
        KafkaTemplate template = new KafkaTemplate(producerFactory);
        template.setDefaultTopic(kafkaItemWriterProperties.getTopic());
        return new KafkaItemWriterBuilder().delete(kafkaItemWriterProperties.isDelete()).kafkaTemplate(template).itemKeyMapper(itemKeyMapper).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"batchItemKeyMapper"})
    public Converter<Map<String, Object>, Object> batchItemKeyMapper() {
        return new Converter<Map<String, Object>, Object>(){

            public Object convert(Map<String, Object> source) {
                return source;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    ProducerFactory<Object, Map<String, Object>> producerFactory() {
        HashMap configs = new HashMap();
        configs.putAll(this.kafkaProperties.getProducer().buildProperties());
        return new DefaultKafkaProducerFactory(configs, null, (Serializer)new JsonSerializer());
    }

    private void validateProperties(KafkaItemWriterProperties kafkaItemWriterProperties) {
        Assert.hasText((String)kafkaItemWriterProperties.getTopic(), (String)"topic must not be empty or null");
    }
}

