/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure;

import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.SingleStepJobProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SingleStepJobProperties.class})
@AutoConfigureBefore(value={BatchAutoConfiguration.class})
public class SingleStepJobAutoConfiguration {
    private JobBuilderFactory jobBuilderFactory;
    private StepBuilderFactory stepBuilderFactory;
    private SingleStepJobProperties properties;
    @Autowired(required=false)
    private ItemProcessor<Map<String, Object>, Map<String, Object>> itemProcessor;

    public SingleStepJobAutoConfiguration(JobBuilderFactory jobBuilderFactory, StepBuilderFactory stepBuilderFactory, SingleStepJobProperties properties, ApplicationContext context) {
        this.validateProperties(properties);
        this.jobBuilderFactory = jobBuilderFactory;
        this.stepBuilderFactory = stepBuilderFactory;
        this.properties = properties;
    }

    private void validateProperties(SingleStepJobProperties properties) {
        Assert.hasText((String)properties.getJobName(), (String)"A job name is required");
        Assert.hasText((String)properties.getStepName(), (String)"A step name is required");
        Assert.notNull((Object)properties.getChunkSize(), (String)"A chunk size is required");
        Assert.isTrue((properties.getChunkSize() > 0 ? 1 : 0) != 0, (String)"A chunk size greater than zero is required");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job", name={"job-name"})
    public Job job(ItemReader<Map<String, Object>> itemReader, ItemWriter<Map<String, Object>> itemWriter) {
        SimpleStepBuilder stepBuilder = this.stepBuilderFactory.get(this.properties.getStepName()).chunk(this.properties.getChunkSize().intValue()).reader(itemReader);
        stepBuilder.processor(this.itemProcessor);
        TaskletStep step = stepBuilder.writer(itemWriter).build();
        return this.jobBuilderFactory.get(this.properties.getJobName()).start((Step)step).build();
    }
}

